/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum ObraAssessment {
    ADMISSION(1, "Admission assessment (required by day 14)"),
    QUARTERLY_REVIEW(2, "Quarterly review assessment"),
    ANNUAL(3, "Annual assessment"),
    STATUS_CHANGE(4, "Significant change in status assessment"),
    COMPREHENSIVE_CORRECTION(5, "Significant correction to prior comprehensive assessment"),
    QUARTERLY_CORRECTION(6, "Significant correction to prior quarterly assessment"),
    NONE(99, "None of the above");

    private Integer value;
    private String description;
    private static final Map<Integer, ObraAssessment> valueMap;

    private ObraAssessment(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static Optional<ObraAssessment> of(Integer value) {
        return Optional.ofNullable(valueMap.get(value));
    }

    static {
        valueMap = new HashMap<Integer, ObraAssessment>();
        for (ObraAssessment obraAssessment : ObraAssessment.values()) {
            valueMap.put(obraAssessment.value, obraAssessment);
        }
    }
}

