/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data;
import gov.cms.grouper.snf.model.SnfProcessException;
import gov.cms.grouper.snf.model.enums.PdxEligibility;
import gov.cms.grouper.snf.model.table.BasicRow;

public class ClinicalCategoryMasterRow
extends BasicRow {
    private String code;
    private String clinicalCategory;
    private PdxEligibility pdxEligibility;

    private ClinicalCategoryMasterRow() {
    }

    public ClinicalCategoryMasterRow(String code, Integer lowVersion, Integer highVersion, String clinicalCategory, PdxEligibility pdxEligibility) {
        super(lowVersion, highVersion);
        this.code = code;
        this.clinicalCategory = clinicalCategory;
        this.pdxEligibility = pdxEligibility;
    }

    public static ClinicalCategoryMasterRow build(Data.ClinicalCategoryMaster row) {
        return new ClinicalCategoryMasterRow(row.getCode(), row.getLowVersion(), row.getHighVersion(), row.getClinicalCategory(), PdxEligibility.of(row.getPdxEligibility()).orElseThrow(() -> new SnfProcessException(row.getPdxEligibility() + " not found. Data issue!")));
    }

    public String getCode() {
        return this.code;
    }

    public String getClinicalCategory() {
        return this.clinicalCategory;
    }

    public PdxEligibility getPdxEligibility() {
        return this.pdxEligibility;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = super.getHashCode(result, 31);
        result = 31 * result + (this.clinicalCategory == null ? 0 : this.clinicalCategory.hashCode());
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.pdxEligibility == null ? 0 : this.pdxEligibility.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClinicalCategoryMasterRow other = (ClinicalCategoryMasterRow)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.clinicalCategory == null ? other.clinicalCategory != null : !this.clinicalCategory.equals(other.clinicalCategory)) {
            return false;
        }
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        return !(this.pdxEligibility == null ? other.pdxEligibility != null : this.pdxEligibility != other.pdxEligibility);
    }
}

