/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.process;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.enums.AssessmentType;
import gov.cms.grouper.snf.model.enums.Rai300;
import gov.cms.grouper.snf.transfer.ISnfClaim;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnfValidations {
    private static final Logger log = LoggerFactory.getLogger(SnfValidations.class);
    private static final Pattern pattern = Pattern.compile("([A-Za-z][0-9][0-9A-Za-z]\\.[0-9A-Za-z^]{4})|(\\^)");
    private final ISnfClaim snfClaim;

    public SnfValidations(ISnfClaim snfClaim) {
        this.snfClaim = snfClaim;
    }

    public static void validateInputs(ISnfClaim snfClaim) {
        if (!SnfValidations.validateDiagnosisPattern(snfClaim.getPrimaryDiagnosis().getValue())) {
            SnfContext.trace("Invalid principal diagnosis code pattern");
        } else if (!SnfValidations.validateAssessments(snfClaim.getAssessmentMap())) {
            SnfContext.trace("Invalid assessment value");
        }
    }

    protected static boolean validateAssessments(Map<String, Assessment> assessmentMap) {
        boolean isAllValueValid = true;
        List validAssessments = assessmentMap.values().stream().filter(assessment -> {
            boolean result = false;
            Optional<Rai300> maybeRai300 = Rai300.of(assessment.getItem());
            if (maybeRai300.isPresent()) {
                AssessmentType assessmentType = maybeRai300.get().getAssessmentType();
                if (!AssessmentType.getNonAssessmentSpecificTypes().contains((Object)assessmentType) && assessment.getValueInt() != Integer.MIN_VALUE) {
                    result = true;
                }
            } else {
                log.warn("Invalid assessment item '{}' provided", (Object)assessment.getItem());
            }
            return result;
        }).collect(Collectors.toList());
        for (Assessment assessment2 : validAssessments) {
            List<Integer> validValues = Rai300.valueOf(assessment2.getItem()).getValidValues();
            if (assessment2.getValueInt() > validValues.get(0) && assessment2.getValueInt() < validValues.get(1) || validValues.contains(assessment2.getValueInt())) continue;
            log.warn("Item " + assessment2.getItem() + " has invalid value of: " + assessment2.getValueInt());
            isAllValueValid = false;
        }
        return isAllValueValid;
    }

    protected static boolean validateDiagnosisPattern(String code) {
        int caretIndex;
        int caret = 94;
        boolean isMatch = pattern.matcher(code).matches();
        if (isMatch && (caretIndex = code.indexOf(94)) != -1) {
            for (int i = caretIndex; i < code.length(); ++i) {
                if (code.charAt(i) == '^') continue;
                return false;
            }
        }
        return isMatch;
    }
}

