package gov.cms.grouper.snf;

import gov.cms.grouper.snf.model.enums.ObraAssessment;
import gov.cms.grouper.snf.model.enums.PpsAssessment;
import gov.cms.grouper.snf.model.enums.SnfError;
import gov.cms.grouper.snf.transfer.ISnfClaim;
import java.io.IOException;
import com.mmm.his.cer.foundation.Processable;
import com.mmm.his.cer.foundation.exception.FoundationException;

/**
 * This is the base component structure that the versioned components. This class and its extended
 * classes should ensure that the 'scoring' is thread safe and be configurable with a minimal of
 * outside setup.
 */
public abstract class SnfComponentAbstract
    implements Processable<ISnfClaim, SnfOption, SnfRuntimeOption> {

  private final int dataVersion;

  protected SnfComponentAbstract(int dataVersion) {
    this.dataVersion = dataVersion;
  }

  /**
   * This checks for a valid claim and if valid, then scores the claim.
   *
   * @param claim non-null SnfClaim.
   * @throws FoundationException rarely would happen
   */
  @Override
  public void process(ISnfClaim claim) throws FoundationException {
    // Validate claim information
    SnfError validationError = this.validates(claim);

    if (validationError == null) {
      this.exec(claim);

    } else {
      claim.addErrors(validationError.getReason());
    }

  }


  public abstract Boolean isInterimPayment(PpsAssessment ppsValue, ObraAssessment obraValue);

  public abstract void exec(ISnfClaim claim);

  /**
   * Validates the claim using Rai300 enums.
   *
   * @param claim non-null claim.
   * @return non-null Error
   */
  public abstract SnfError validates(ISnfClaim claim);

  @Override
  public void close() throws IOException {
    // TODO Auto-generated method stub

  }

  /**
   * not used
   */
  @Override
  public void reconfigure(SnfRuntimeOption option) throws FoundationException {

  }

  public int getDataVersion() {
    return dataVersion;
  }

}
