package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data.PerformanceRecode;

public class PerformanceRecodeRow extends BasicRow {

  private Integer performanceScore;
  private Integer functionScore;

  private PerformanceRecodeRow() {}

  public PerformanceRecodeRow(Integer lowVersion, Integer highVersion, Integer performanceScore, Integer functionScore) {
    super(lowVersion, highVersion);
    this.performanceScore = performanceScore;
    this.functionScore = functionScore;
  }

  public static PerformanceRecodeRow build(PerformanceRecode recode) {
    return new PerformanceRecodeRow(recode.getLowVersion(), recode.getHighVersion(),
        recode.getPerformanceScore(), recode.getFunctionScore());
  }

  public Integer getPerformanceScore() {
    return performanceScore;
  }

  public Integer getFunctionScore() {
    return functionScore;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result = prime * result + ((functionScore == null) ? 0 : functionScore.hashCode());
    result =
        prime * result + ((performanceScore == null) ? 0 : performanceScore.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    PerformanceRecodeRow other = (PerformanceRecodeRow) obj;
    if (super.equals(other) == false) {
      return false;
    }

    if (functionScore == null) {
      if (other.functionScore != null) {
        return false;
      }
    } else if (!functionScore.equals(other.functionScore)) {
      return false;
    }
    if (performanceScore == null) {
      if (other.performanceScore != null) {
        return false;
      }
    } else if (!performanceScore.equals(other.performanceScore)) {
      return false;
    }
    return true;
  }

}
