package gov.cms.grouper.snf.r4;


import gov.cms.grouper.snf.SnfComponentVersion;
import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.model.enums.ObraAssessment;
import gov.cms.grouper.snf.model.enums.PpsAssessment;

public class SnfComponent extends gov.cms.grouper.snf.r3.SnfComponent {

  public SnfComponent() {
    this(220);
  }

  public SnfComponent(int dataVersion) {
    super(dataVersion);
    if (dataVersion < SnfComponentVersion.r4.getFrom()
      && dataVersion > SnfComponentVersion.r4.getTo()) {
      throw new RuntimeException("Version mismatch");
    }
  }


  /**
   * If PPS value is available (not being null/NONE), it will drive this logic.
   * Otherwise, OBRA will drive this logic
   */
  @Override
  public Boolean isInterimPayment(PpsAssessment ppsValue, ObraAssessment obraValue) {
    /* Change in requirement effective 10/01/2023
      When it is standalone obra assessment, obra is 2 - 6 and pps is 99
      Then it is considered interim so GGXXXXX5 fields are used instead of GGXXXXX1 fields.
     */
    if (obraValue != null
            && obraValue != ObraAssessment.ADMISSION
            && obraValue != ObraAssessment.NONE
            && (ppsValue == null || ppsValue == PpsAssessment.NONE)) {
      return SnfContext.trace(true);
    } else {
      return SnfContext.trace(super.isInterimPayment(ppsValue, obraValue));
    }
  }


}
