package gov.cms.grouper.snf;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnfContext {

  public static final String KEY_FMT = "%s.%s: %s";
  public static final String MSG_FMT = "%s: %s";
  private static final Logger log = LoggerFactory.getLogger(SnfContext.class);

  private SnfContext() {

  }

  public static <T, RT> RT trace(T input, RT result) {
    return SnfContext.traceImpl(null, input, result);
  }

  private static <T, RT> RT traceImpl(String messageKey, T input, RT result) {
    if (log.isDebugEnabled()) {
      Throwable th = new Throwable();
      StackTraceElement st = th.getStackTrace()[2];
      String clazz = st.getClassName();
      String method = st.getMethodName();
      messageKey = String.format(SnfContext.KEY_FMT, clazz, method, messageKey);
      log.debug(String.format(MSG_FMT, messageKey, input));
    }

    return result;
  }

  public static <T> T trace(String messageKey, T result) {
    return SnfContext.traceImpl(messageKey, result, result);
  }

  public static <T> T trace(T result) {
    return SnfContext.traceImpl("", result, result);
  }

}
