package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data.CmgForPtOt;

public class CmgForPtOtRow extends BasicRow {

  private String clinicalCategory;
  private Integer functionScoreLow;
  private Integer functionScoreHigh;
  private String cmg;

  private CmgForPtOtRow() {}

  public CmgForPtOtRow(Integer lowLevel, Integer highLevel, String clinicalCategory, Integer functionScoreLow, Integer functionScoreHigh,
      String cmg) {
    super(lowLevel,highLevel);
    this.clinicalCategory = clinicalCategory;
    this.functionScoreLow = functionScoreLow;
    this.functionScoreHigh = functionScoreHigh;
    this.cmg = cmg;
  }

  public String getClinicalCategory() {
    return clinicalCategory;
  }

  public Integer getFunctionScoreLow() {
    return functionScoreLow;
  }

  public Integer getFunctionScoreHigh() {
    return functionScoreHigh;
  }

  public String getCmg() {
    return cmg;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = getHashCode(result, prime);
    result =
        prime * result + ((clinicalCategory == null) ? 0 : clinicalCategory.hashCode());
    result = prime * result + ((cmg == null) ? 0 : cmg.hashCode());
    result =
        prime * result + ((functionScoreHigh == null) ? 0 : functionScoreHigh.hashCode());
    result =
        prime * result + ((functionScoreLow == null) ? 0 : functionScoreLow.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    CmgForPtOtRow other = (CmgForPtOtRow) obj;
    if (super.equals(other) == false) {
      return false;
    }

    if (clinicalCategory == null) {
      if (other.clinicalCategory != null) {
        return false;
      }
    } else if (!clinicalCategory.equals(other.clinicalCategory)) {
      return false;
    }
    if (cmg == null) {
      if (other.cmg != null) {
        return false;
      }
    } else if (!cmg.equals(other.cmg)) {
      return false;
    }
    if (functionScoreHigh == null) {
      if (other.functionScoreHigh != null) {
        return false;
      }
    } else if (!functionScoreHigh.equals(other.functionScoreHigh)) {
      return false;
    }
    if (functionScoreLow == null) {
      if (other.functionScoreLow != null) {
        return false;
      }
    } else if (!functionScoreLow.equals(other.functionScoreLow)) {
      return false;
    }
    return true;
  }

  public static CmgForPtOtRow build(CmgForPtOt cmg) {
    return new CmgForPtOtRow(cmg.getLowVersion(), cmg.getHighVersion(), cmg.getClinicalCategory(),
        cmg.getFunctionScoreLow(), cmg.getFunctionScoreHigh(), cmg.getCmg());
  }

  @Override
  public String toString() {
    return "CmgForPtOtRow{" +
            "clinicalCategory='" + clinicalCategory + '\'' +
            ", functionScoreLow=" + functionScoreLow +
            ", functionScoreHigh=" + functionScoreHigh +
            ", cmg='" + cmg + '\'' +
            '}';
  }
}
