/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.app;

import com.mmm.his.cer.foundation.model.ICode;
import gov.cms.grouper.snf.app.Pdpm;
import gov.cms.grouper.snf.lego.ActionWrapper;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.lego.SupplierWithException;
import gov.cms.grouper.snf.lego.Triple;
import gov.cms.grouper.snf.model.reader.Rai300;
import gov.cms.grouper.snf.transfer.SnfClaim;
import gov.cms.grouper.snf.util.ClaimInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class PdpmTest {
    private static final Function<Integer, Integer> increment = counter -> {
        counter = counter + 1;
        return counter;
    };
    private static final String numOfCorrectKey = "numOfCorrect";
    private static final String misMatchHippsCounterKey = "misMatchHippsCount";
    public static final String totalNumberRecordKey = "numberOfRecords";
    public static final String errorCounterKey = "errorCount";
    public static final Logger logger = LogManager.getLogger();
    private static long begin = System.currentTimeMillis();
    private static long end = System.currentTimeMillis();
    private static ActionWrapper<String, Integer> counters;

    public static void main(String[] args) throws Throwable {
        File[] files;
        int ver;
        boolean dryRun = "true".equals(System.getProperty("dryRun"));
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        String logLevel = System.getProperty("snfLog");
        if (logLevel != null) {
            System.out.println("*******************");
            logger.debug("log4j " + logLevel + " On");
            loggerConfig.setLevel(Level.valueOf(logLevel));
        } else {
            loggerConfig.setLevel(Level.OFF);
        }
        ctx.updateLoggers();
        String outputPath = "test_results/";
        String inputPath = "test_data";
        Integer initVersion = null;
        if (args.length > 0 && (ver = Integer.parseInt(args[0])) >= 0) {
            initVersion = ver;
        }
        Integer version = initVersion;
        if (args.length > 1) {
            inputPath = args[1];
        }
        Path inputDir = Paths.get(inputPath, new String[0]);
        Path outputDir = Paths.get(outputPath, new String[0]);
        if (!dryRun) {
            outputDir.toFile().mkdirs();
        }
        if (version == null) {
            System.out.println("*** running with version: <current> testDataDirectory: " + inputDir.getFileName());
        } else {
            System.out.println("*** running with version: " + version + " testDataDirectory: " + inputDir.getFileName());
        }
        for (File file : files = inputDir.toFile().listFiles(pathname -> !pathname.isDirectory() && pathname.getName().endsWith(".txt"))) {
            System.out.println("**** Processing File: " + file.getName());
            PdpmTest.beginPerformanceTime();
            SupplierWithException<Writer> ws = PdpmTest.getWriter(dryRun, inputDir, file, outputDir);
            Function<Writer, Consumer<SnfClaim>> getProcessing = PdpmTest.qaProcessing(dryRun, counters);
            Consumer<Writer> exec = PdpmTest.getExec(dryRun, version, file, getProcessing);
            PdpmTest.doMain(version, file, ws, exec);
            PdpmTest.endPerformanceTime();
            System.out.println("***********************************");
        }
    }

    protected static void doMain(Integer version, File inputFile, SupplierWithException<Writer> ws, Consumer<Writer> exec) throws Throwable {
        try (Writer writer = (Writer)ws.get();){
            exec.accept(writer);
        }
        catch (Throwable ex) {
            System.out.println("ERROR WHILE PROCESSING: " + inputFile.getAbsolutePath());
            throw new RuntimeException(ex);
        }
    }

    protected static SupplierWithException<Writer> getWriter(boolean dryRun, Path inputDir, File inputFile, Path resultDir) {
        SupplierWithException ws = () -> new Writer(){

            @Override
            public void write(String str) throws IOException {
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }
        };
        if (!dryRun) {
            String inputRelDir = inputFile.getParentFile().getAbsolutePath().replace(inputDir.toFile().getAbsolutePath(), "");
            String resultFilePath = resultDir.toFile().getAbsolutePath() + inputRelDir;
            File resultFileDir = new File(resultFilePath);
            resultFileDir.mkdirs();
            File resultFile = new File(resultFileDir.getAbsolutePath() + "/" + inputFile.getName());
            ws = () -> new BufferedWriter(new FileWriter(resultFile));
        }
        return ws;
    }

    protected static void beginPerformanceTime() {
        begin = System.currentTimeMillis();
        List<Triple> counterEntries = Arrays.asList(Triple.of((Object)0, (Object)numOfCorrectKey, increment), Triple.of((Object)0, (Object)misMatchHippsCounterKey, increment), Triple.of((Object)0, (Object)totalNumberRecordKey, increment), Triple.of((Object)0, (Object)errorCounterKey, increment));
        counters = new ActionWrapper(counterEntries);
        end = System.currentTimeMillis();
    }

    protected static void endPerformanceTime() {
        end = System.currentTimeMillis();
        Integer totalNumberOfRecords = (Integer)counters.getValue((Object)totalNumberRecordKey);
        Integer errorCount = (Integer)counters.getValue((Object)errorCounterKey);
        Integer numberOfCorrect = (Integer)counters.getValue((Object)numOfCorrectKey);
        Integer misMatchHippsCount = (Integer)counters.getValue((Object)misMatchHippsCounterKey);
        PdpmTest.performanceTime(begin, end, totalNumberOfRecords, errorCount, misMatchHippsCount, numberOfCorrect);
    }

    protected static void formatFixedLengthValue(StringBuilder sb, Rai300 field, boolean rightJustified, String value) {
        String justification = rightJustified ? "" : "-";
        sb.replace(field.getIndex() - 1, field.getIndex() + field.getLength() - 1, String.format("%1$" + justification + field.getLength() + "s", value));
    }

    private static void performanceTime(long begin, long end, int totalNumberOfRecords, int errorCount, Integer misMatchHippsCount, Integer numberOfCorrect) {
        long processTime;
        long min = (processTime = end - begin) / 60000L;
        long sec = processTime % ((min == 0L ? 1L : min) * 1000L * 60L) / 1000L;
        long totalSec = processTime / 1000L;
        if (numberOfCorrect != null) {
            double percentage = (double)numberOfCorrect.intValue() * 100.0 / (double)totalNumberOfRecords;
            System.out.println("\t\tRecords Processed: " + totalNumberOfRecords);
            int errors = errorCount + misMatchHippsCount;
            if (errors != 0) {
                double errorPercent = 100.0 - percentage;
                System.out.println("\t\terrors: " + errors + " (" + errorPercent + "%)");
            }
        } else {
            System.out.println("\t\tRecords Processed: " + totalNumberOfRecords);
            System.out.println("\t\terrors: " + errorCount);
        }
        String intervalFmt = "\t\ttotal process time with %d records = %d min and %d sec (%d Seconds)";
        System.out.println(String.format(intervalFmt, totalNumberOfRecords, min, sec, totalSec));
        long recordPerSecond = totalNumberOfRecords;
        if (totalSec > 0L) {
            recordPerSecond = (long)totalNumberOfRecords / totalSec;
        }
        System.out.println(String.format("\t\trecords per second = %d", recordPerSecond));
    }

    public static void printUsage() {
        System.out.println("to use applicable associated assessment date version in the record: java -jar snf-1.1.jar -1 My/File/Directory my/Result/Dir");
        System.out.println("to turn on log java -cp snf-{snfVersion}.jar -DsnfLog=ON gov.cms.grouper.snf.app.Pdpm {version} My/File/Directory my/Result/Dir");
        System.out.println("please provide test files directory as args, example: java -jar snf-1.1.jar {version} My/File/Directory my/Result/Dir");
    }

    protected static Consumer<Writer> getExec(boolean dryRun, Integer version, File inputFile, Function<Writer, Consumer<SnfClaim>> getProcessing) {
        Consumer<Writer> exec = writer -> {
            Consumer processing = (Consumer)getProcessing.apply((Writer)writer);
            ArrayList errors = new ArrayList();
            Pdpm pdpm = new Pdpm(errors);
            pdpm.processFile(inputFile.toPath(), line -> {
                pdpm.exec(version, line, processing);
                return line;
            });
        };
        return exec;
    }

    protected static Function<Writer, Consumer<SnfClaim>> qaProcessing(boolean dryRun, ActionWrapper<String, Integer> counters) throws Throwable {
        Function<Writer, Consumer<SnfClaim>> r = writer -> claim -> {
            counters.doAction((Object)totalNumberRecordKey);
            StringBuilder sb = new StringBuilder(claim.getOriginalRecord());
            String expected = PdpmTest.getOriginalRecordHippsCode(claim);
            String actual = claim.getHippsCode();
            if (claim.hasError()) {
                counters.doAction((Object)errorCounterKey);
                PdpmTest.formatFixedLengthValue(sb, Rai300.ERROR_REASON, false, claim.getErrors().toString());
                PdpmTest.formatFixedLengthValue(sb, Rai300.RECALCULATED_Z0100A, false, claim.getHippsCode());
                PdpmTest.formatFixedLengthValue(sb, Rai300.RECALCULATED_Z0100B, false, claim.getRecalculated_z0100b());
                sb.append(System.lineSeparator());
            } else if (!expected.equals(actual)) {
                PdpmTest.formatFixedLengthValue(sb, Rai300.RECALCULATED_Z0100A, false, claim.getHippsCode());
                PdpmTest.formatFixedLengthValue(sb, Rai300.RECALCULATED_Z0100B, false, claim.getRecalculated_z0100b());
                counters.doAction((Object)misMatchHippsCounterKey);
                PdpmTest.formatFixedLengthValue(sb, Rai300.ERROR_REASON, false, "Z0100A & Recalculated_Z0100A mismatched.");
                sb.append(System.lineSeparator());
            } else {
                PdpmTest.formatFixedLengthValue(sb, Rai300.RECALCULATED_Z0100A, false, claim.getHippsCode());
                PdpmTest.formatFixedLengthValue(sb, Rai300.RECALCULATED_Z0100B, false, claim.getRecalculated_z0100b());
                counters.doAction((Object)numOfCorrectKey);
                sb.append(System.lineSeparator());
            }
            if (!dryRun) {
                SnfUtils.doOrDie(() -> writer.write(sb.toString()));
            }
        };
        return r;
    }

    private static String getOriginalRecordHippsCode(SnfClaim claim) {
        int start = Rai300.Z0100A.getIndex() - 1;
        int end = start + Rai300.Z0100A.getLength() - 1;
        return claim.getOriginalRecord().substring(start, end).trim();
    }

    @Test
    public void readAllLinesToClaimsTest() throws Exception {
        Pdpm pdpm = new Pdpm();
        String line = "MDS       NC 1.17      3.00      PIA765045          521230861CMS                           help@qtso.com                                     jRAVEN                                            1.1.9               ^                   ^         765045      ^              10101  0103FPDPMf150   ^GrprNRSEf150      ^  9990211505GR1PR1NR50 ^              1193205010000010^              4^           ^         ^                      ^                      0100000201910011012019100601^       201910060^       ^       0010000112121222120^^^^^^^^     111101111111111111108 ^^^^^^^^^^^^^^^^^^^^^  0010000^^^^^^00^^31111212232332221110^^^^^^^^^^^^^^^^^^^^^11110000000000000000000000000000010000010---0000011000000000000001000000000000000100000010000010000000000^       ^       ^       ^       ^       ^       ^       ^       ^       ^       00010^^^^ ^^^^^^^^100000000011110^^^00010671272       00000001000100^^^        ^^^^^^^^^^                    0000000100000000010^^        0000000001010001000000 0010120191001^1^200 -   -   52019100120191005200 -   -   52019100120191005200 -   -   5201910012019100515  115  115  17700006000- - 00000000109^^1  ^2049920191001- - - 0-1-0-0-1-1-101-0-1010100-100-10100-0-0-20191006201910061^^           ^                 ^^       ^        ^ ^    ^       ^       ^       ^ ^^^^^^^^           ^                 ^       KIAA1  1.0003                      RAA       1.0448    RAA       1.0448    20191006^           1^^^01100 1 000001234567^^^ 32 12-   -   -   520191001011000401^ 0501^ 0401^ 0603^ 0605^ 0505^ 0506^ 0502^   0603^ 0605^ 1^0404^ 1^0505^ 1^^0112019100512019100511111132181000000605^ 0302^ 0709^ 88- ^ 0605^ 0106^ 0403^ 0403^ 0403^ 0403^ 88- ^ 0403^ 13        111^0^1^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ A20.7^^^111111111111111111111111111111^   ^   ^   ^   ^  ^   ^   ^   ^   ^  ^   ^   ^   ^   ^  ^    ^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              KIAA1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  %";
        SnfClaim claim = pdpm.transformToClaim(line);
        Assertions.assertEquals((Object)"A20.7^^^", (Object)claim.getPrimaryDiagnosis().getValue());
        Assertions.assertEquals((int)1, (int)claim.getAiCode());
        Assertions.assertEquals((int)1, (int)claim.getObra());
        ClaimInfo claimUtil = new ClaimInfo(100, false, claim.getAssessments());
        Assertions.assertEquals((int)7, (int)claimUtil.getAssessmentValue(Rai300.O0500A));
    }

    @Test
    public void getVersionTest() {
        Pdpm pdpm = new Pdpm();
        Assertions.assertEquals((int)104, (Integer)pdpm.getDataVersion(LocalDate.of(2020, 4, 1)));
        Assertions.assertEquals((int)103, (Integer)pdpm.getDataVersion(LocalDate.of(2019, 10, 1)));
        Assertions.assertNull((Object)pdpm.getDataVersion(LocalDate.of(2019, 9, 30)));
    }

    @Test
    public void execLineTest() {
        String line = "MDS       NC 1.17      3.00      PIA765045          521230861CMS                           help@qtso.com                                     jRAVEN                                            1.1.9               ^                   ^         765045      ^              10199  0993CATchgJAN01 ^LNCJ2100_001      ^  9990181011CD0CC6jj01 ^              11940    0000011SIGN           3^           ^         ^                      ^                      000000120201227101^       ^ ^       202101010^       ^       0010000113321222150^^^^^^^^     19^9^9^9^9^9^9^9^1399 000000000011111111115  0010000^^^^^^00^^31111212232332221110^^^^^^^^^^^^^^^^^^^^^00000000000000000000000000000000011100000---0000011000000000000000100001000000000000000000000010000000000U07.1^^^S32.10XDE11.8^^^Z79.4^^^W19.XXXDI85.01^^S32.502DG47.00^^S32.059DK75.81^^00010^^^^ ^^^^^^^^100000000011110^^^00001681650       0000000100010----        --^-------                    000000011100000000---        0000000000000000000000 0111120201231^1^200 -   -   52020122920201231200 -   -   52020122920201231200 -   -   5202012292020123115  -15  115  10000000000- - 00000000109^^1  ^2049920201231- - - 0-1-0-0-1-0-00100-0010100-100-01100-0-0-20210106202101071^^           ^                 ^^       ^        ^ ^    ^       ^       ^       ^ ^^^^^^^^           ^                 ^       KACD   1.0009                      RAA       1.0448    RAA       1.0448    20210106^           ^^^^00000 0 011001234567^^^ ^^ ^^-   -   -   5202012270110005^ ^ 05^ ^ 01^ ^ 02^ ^ 03^ ^ 02^ ^ 04^ ^ 04^ ^   ^ ^ ^ ^ ^ ^ 1^04^ ^ 1^05^ ^ 1^^01120210104120210104111111^^^^^^^^^^06^ ^ 03^ ^ 07^ ^ 88^ ^ 06^ ^ 01^ ^ 88^ ^ ^ ^ ^ 04^ ^ 04^ ^ 88^ ^ 04^ ^ 13        ^^^^0 ^                      J12.82^^111111111111111000000000000001^   ^   ^   ^   ^  ^   ^   ^   ^   ^  ^   ^   ^   ^   ^  ^    ^1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             KACD   1.0009                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          %";
        Pdpm pdpm = new Pdpm(null);
        SnfClaim claim = pdpm.transformToClaim(line);
        SnfClaim finishedClaim = pdpm.process(claim);
        Assert.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(finishedClaim), (Object)finishedClaim.getHippsCode());
    }

    @Test
    public void execU071Test() throws Exception {
        Object claim22;
        int version = 104;
        Path path = (Path)SnfUtils.doOrDie(() -> Paths.get(ClassLoader.getSystemResource("U071 test.txt").toURI()));
        Pdpm pdpm = new Pdpm();
        Consumer<SnfClaim> test = claim -> Assert.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        pdpm.exec(Integer.valueOf(version), path, test);
        List results = pdpm.exec(Integer.valueOf(version), path);
        for (Object claim22 : results) {
            Assert.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode((SnfClaim)claim22), (Object)claim22.getHippsCode());
        }
        ArrayList lines = new ArrayList();
        pdpm.processFile(path, line -> {
            lines.add(line);
            return line;
        });
        results = pdpm.exec(Integer.valueOf(version), lines);
        for (SnfClaim claim3 : results) {
            Assert.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim3), (Object)claim3.getHippsCode());
        }
        claim22 = pdpm.transformToClaim((String)lines.get(0));
        claim22 = pdpm.execClaim(Integer.valueOf(version), (SnfClaim)claim22);
        Assert.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode((SnfClaim)claim22), (Object)claim22.getHippsCode());
        claim22 = pdpm.exec(Integer.valueOf(version), (String)lines.get(0));
        Assert.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode((SnfClaim)claim22), (Object)claim22.getHippsCode());
        pdpm = (Pdpm)Mockito.spy((Object)pdpm);
        ((Pdpm)Mockito.doReturn(null).when((Object)pdpm)).getDataVersion((LocalDate)ArgumentMatchers.any());
        claim22 = (SnfClaim)Mockito.spy((Object)claim22);
        ((SnfClaim)Mockito.doThrow(RuntimeException.class).when(claim22)).getPrimaryDiagnosis();
        ((SnfClaim)Mockito.doThrow(NullPointerException.class).when(claim22)).addCode((ICode)ArgumentMatchers.any());
    }

    @Test
    public void tryExecTest() {
        Pdpm pdpm = new Pdpm(null);
        try {
            pdpm.tryExec("", () -> {
                throw new Exception("error");
            });
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void execNTATest() throws Exception {
        Path path = (Path)SnfUtils.doOrDie(() -> Paths.get(ClassLoader.getSystemResource("NTA test.txt").toURI()));
        Pdpm pdpm = new Pdpm();
        Consumer<SnfClaim> test = claim -> Assertions.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        pdpm.exec(null, path, test);
    }

    @Test
    public void execNurseTest() throws Exception {
        Path path = (Path)SnfUtils.doOrDie(() -> Paths.get(ClassLoader.getSystemResource("Nurse test.txt").toURI()));
        Pdpm pdpm = new Pdpm();
        Consumer<SnfClaim> test = claim -> Assertions.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        pdpm.exec(Integer.valueOf(103), path, test);
    }

    @Test
    public void execPTOTTest() throws Exception {
        Path path = (Path)SnfUtils.doOrDie(() -> Paths.get(ClassLoader.getSystemResource("PTOT test.txt").toURI()));
        Pdpm pdpm = new Pdpm();
        Consumer<SnfClaim> test = claim -> Assertions.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        pdpm.exec(Integer.valueOf(103), path, test);
    }

    @Test
    public void execSLPTest() throws Exception {
        Path path = (Path)SnfUtils.doOrDie(() -> Paths.get(ClassLoader.getSystemResource("SLP test.txt").toURI()));
        Pdpm pdpm = new Pdpm();
        Consumer<SnfClaim> test = claim -> Assertions.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        pdpm.exec(Integer.valueOf(103), path, test);
        pdpm.exec(Integer.valueOf(103), path);
    }

    @Test
    public void getClaimFixedStringTest() throws Exception {
        Path path = (Path)SnfUtils.doOrDie(() -> Paths.get(ClassLoader.getSystemResource("Nurse test.txt").toURI()));
        Pdpm pdpm = new Pdpm();
        AtomicReference first = new AtomicReference();
        Consumer<SnfClaim> test = claim -> {
            if (first.get() == null) {
                first.set(claim);
            }
            Assertions.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        };
        pdpm.exec(Integer.valueOf(103), path, test);
        String hipps = "AFAA1  ";
        SnfClaim claim2 = (SnfClaim)first.get();
        claim2.setHippsCode(hipps);
        StringBuilder sb = new StringBuilder(claim2.getOriginalRecord());
        PdpmTest.formatFixedLengthValue(sb, Rai300.RECALCULATED_Z0100A, false, claim2.getHippsCode());
        PdpmTest.formatFixedLengthValue(sb, Rai300.RECALCULATED_Z0100B, false, claim2.getRecalculated_z0100b());
        Assertions.assertEquals((Object)sb.toString(), (Object)pdpm.getClaimFixedString(claim2));
    }

    @Test
    @Order(value=0)
    public void testMain() throws Throwable {
        System.setProperty("dryRun", "true");
        Path dir = (Path)SnfUtils.doOrDie(() -> Paths.get(ClassLoader.getSystemResource("mainTest").toURI()));
        dir.toFile().list();
        String testFileDir = dir.toString();
        String[] args = new String[]{"-1", testFileDir};
        boolean s = false;
        try {
            PdpmTest.main(args);
            args = new String[]{"100", testFileDir};
            PdpmTest.main(args);
            s = true;
            Assertions.assertTrue((boolean)s);
        }
        catch (Exception ex) {
            Assertions.fail();
        }
        s = false;
        try {
            args = new String[]{"-1", testFileDir, "blah"};
            PdpmTest.main(args);
            s = true;
            Assertions.assertTrue((boolean)s);
        }
        catch (Exception ex) {
            Assertions.fail();
        }
    }
}

