/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf;

import com.mmm.his.cer.foundation.ComponentVersion;
import gov.cms.grouper.snf.component.r2.SnfComponent;
import gov.cms.grouper.snf.lego.SnfComparator;
import gov.cms.grouper.snf.model.SnfComponentAbstract;
import java.util.function.Function;

public enum SnfComponentVersion implements ComponentVersion
{
    r2(100, 104, dataVersion -> new SnfComponent((int)dataVersion)),
    r3(105, 200, dataVersion -> new gov.cms.grouper.snf.component.r3.SnfComponent((int)dataVersion));

    private final int from;
    private final int to;
    private final Function<Integer, SnfComponentAbstract> createComponent;

    private SnfComponentVersion(int from, int to, Function<Integer, SnfComponentAbstract> createComponent) {
        this.from = from;
        this.to = to;
        this.createComponent = createComponent;
    }

    public String getPackageValue() {
        return "component." + this.name();
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public Function<Integer, SnfComponentAbstract> getCreateComponent() {
        return this.createComponent;
    }

    public static SnfComponentVersion toSnfComponentVersion(int dataVersion) {
        SnfComponentVersion result = null;
        for (SnfComponentVersion rel : SnfComponentVersion.values()) {
            if (!SnfComparator.betweenInclusive(rel.from, dataVersion, rel.to)) continue;
            result = rel;
            break;
        }
        return result;
    }
}

