/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.component.r2.logic.nursing;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.component.r2.logic.nursing.ReducedPhysicalFunctionLogic;
import gov.cms.grouper.snf.lego.SnfCache;
import gov.cms.grouper.snf.lego.SnfComparator;
import gov.cms.grouper.snf.lego.SnfDataVersionImpl;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.enums.NursingCmg;
import gov.cms.grouper.snf.model.reader.Rai300;
import gov.cms.grouper.snf.util.ClaimInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public class BscpLogic
extends SnfDataVersionImpl<NursingCmg> {
    public static final List<Rai300> behavioralSymptomsRaiList = Arrays.asList(Rai300.E0200A, Rai300.E0200B, Rai300.E0200C, Rai300.E0800, Rai300.E0900);
    public static final List<Rai300> Services = Arrays.asList(Rai300.O0500C, Rai300.O0500E, Rai300.O0500G, Rai300.O0500H, Rai300.O0500I, Rai300.O0500J);
    private final ClaimInfo claim;
    private final Supplier<ReducedPhysicalFunctionLogic> physicalSupplier;
    private final Supplier<Integer> cacheC0500;
    private final Supplier<Integer> cacheC0100;
    private final Supplier<Boolean> isBehavioralSymptomsPresentCache;
    private final Supplier<NursingCmg> physicalCmg;

    public BscpLogic(ClaimInfo claim, Supplier<ReducedPhysicalFunctionLogic> physicalSupplier) {
        super(claim.getDataVersion());
        this.claim = claim;
        this.physicalSupplier = physicalSupplier;
        this.cacheC0500 = SnfCache.of(() -> claim.getAssessmentValue(Rai300.C0500));
        this.cacheC0100 = SnfCache.of(() -> claim.getAssessmentValue(Rai300.C0100));
        this.isBehavioralSymptomsPresentCache = this.getBehavioralSymptomsPresentCache();
        this.physicalCmg = SnfCache.of(() -> ((ReducedPhysicalFunctionLogic)physicalSupplier.get()).exec());
    }

    public List<Assessment> getBehavioralSymptomsAssessmentList(ClaimInfo claim) {
        ArrayList<Assessment> result = new ArrayList<Assessment>();
        for (Rai300 rai : behavioralSymptomsRaiList) {
            Assessment ast = claim.getAssessment(rai);
            if (ast == null) continue;
            result.add(ast);
        }
        return Collections.unmodifiableList(result);
    }

    public boolean isClassifiedBehavioralSymptomsCognitivePerformance() {
        SnfCache.SupplierCache<Boolean> comatoseSupplier = SnfCache.of(() -> this.claim.isComaAndNoActivities(() -> this.claim.getAssessmentValue(Rai300.B0100)));
        boolean result = this.claim.isClassifiedBehavioralSymptomsCognitivePerformance(() -> this.claim.getAssessmentValue(Rai300.B0700), () -> this.claim.getAssessmentValue(Rai300.C0700), () -> this.claim.getAssessmentValue(Rai300.C1000), comatoseSupplier);
        return result;
    }

    public SnfCache.SupplierCache<Boolean> getBehavioralSymptomsPresentCache() {
        SnfCache.SupplierCache<Boolean> cache = SnfCache.of(() -> {
            boolean e0100AChecked = this.claim.isCheckedAndNotNull(Rai300.E0100A);
            boolean e0100BChecked = this.claim.isCheckedAndNotNull(Rai300.E0100B);
            List<Assessment> behavioralSymptomsAssessmentList = this.getBehavioralSymptomsAssessmentList(this.claim);
            boolean hasSymptoms = this.hasSymptoms(behavioralSymptomsAssessmentList);
            return this.isBehavioralSymptomsPresent(e0100AChecked, e0100BChecked, hasSymptoms);
        });
        return cache;
    }

    public boolean isBehavioralSymptomsPresent(boolean e0100AChecked, boolean e0100BChecked, boolean hasSymptoms) {
        boolean result = SnfUtils.any(hasSymptoms, e0100BChecked, e0100AChecked);
        return result;
    }

    public boolean hasSymptoms(List<Assessment> behavioralSymptomsAssessmentList) {
        Assessment ast;
        boolean hasSymptoms = false;
        Iterator<Assessment> iterator = behavioralSymptomsAssessmentList.iterator();
        while (iterator.hasNext() && !(hasSymptoms = (ast = iterator.next()).getValueInt() >= 2)) {
        }
        return hasSymptoms;
    }

    protected NursingCmg step4(boolean isBehavioralSymptomsPresent) {
        NursingCmg result = isBehavioralSymptomsPresent ? this.step6() : this.physicalSupplier.get().exec();
        return SnfContext.trace(result);
    }

    public int step5() {
        int restorativeNursingCount = 0;
        int h0200C = this.claim.getAssessmentValue(Rai300.H0200C);
        int h0500 = this.claim.getAssessmentValue(Rai300.H0500);
        int o0500A = this.claim.getAssessmentValue(Rai300.O0500A);
        int o0500B = this.claim.getAssessmentValue(Rai300.O0500B);
        int o0500D = this.claim.getAssessmentValue(Rai300.O0500D);
        int o0500F = this.claim.getAssessmentValue(Rai300.O0500F);
        if (h0200C == 1 || h0500 == 1) {
            ++restorativeNursingCount;
        }
        if (o0500A >= 6 || o0500B >= 6) {
            ++restorativeNursingCount;
        }
        if (o0500D >= 6 || o0500F >= 6) {
            ++restorativeNursingCount;
        }
        for (Rai300 service : Services) {
            if (this.claim.getAssessmentValue(service) < 6) continue;
            ++restorativeNursingCount;
        }
        return SnfContext.trace(restorativeNursingCount);
    }

    protected NursingCmg step6() {
        int nursingFunctionScore = this.claim.getFunctionScore();
        NursingCmg result = null;
        if (SnfComparator.betweenInclusive(11, nursingFunctionScore, 16)) {
            int step5RestorativeNursingCount = this.step5();
            result = step5RestorativeNursingCount >= 2 ? NursingCmg.BAB2 : NursingCmg.BAB1;
        }
        return SnfContext.trace(result);
    }

    public NursingCmg eval(boolean isClassifiedBehavioralSymptomsCognitivePerformance, Supplier<Integer> cacheC0500, Supplier<Integer> cacheC0100, Supplier<NursingCmg> physicalSupplier) {
        NursingCmg result = null;
        int nursingFunctionScore = this.claim.getFunctionScore();
        result = nursingFunctionScore < 11 ? physicalSupplier.get() : (cacheC0100.get() != 0 && cacheC0500.get() <= 9 && cacheC0100.get() != Integer.MIN_VALUE && cacheC0500.get() != Integer.MIN_VALUE ? this.step6() : (cacheC0100.get() != 0 && cacheC0500.get() > 9 && cacheC0500.get() != 99 ? this.step4(this.isBehavioralSymptomsPresentCache.get()) : (isClassifiedBehavioralSymptomsCognitivePerformance ? this.step6() : this.step4(this.isBehavioralSymptomsPresentCache.get()))));
        return SnfContext.trace(result);
    }

    @Override
    public NursingCmg exec() {
        boolean isClassifiedBehavioralSymptomsCognitivePerformance = this.isClassifiedBehavioralSymptomsCognitivePerformance();
        NursingCmg result = this.eval(isClassifiedBehavioralSymptomsCognitivePerformance, this.cacheC0500, this.cacheC0100, this.physicalCmg);
        return SnfContext.trace(result);
    }

    public static List<Rai300> getBehavioralsymptomsrailist() {
        return behavioralSymptomsRaiList;
    }

    public ClaimInfo getClaim() {
        return this.claim;
    }

    public Supplier<ReducedPhysicalFunctionLogic> getPhysicalSupplier() {
        return this.physicalSupplier;
    }

    public Supplier<Integer> getCacheC0500() {
        return this.cacheC0500;
    }

    public Supplier<Integer> getCacheC0100() {
        return this.cacheC0100;
    }
}

