/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.lego;

import gov.cms.grouper.snf.lego.SnfComparator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Supplier;

public class BetweenCompare<T extends Comparable<T>> {
    public static final int FROM_INCLUSIVE = 1;
    public static final int FROM_EXCLUSIVE = 0;
    public static final int TO_INCLUSIVE = 0;
    public static final int TO_EXCLUSIVE = 1;
    private final SnfComparator.AcceptNull fromAccept;
    private final SnfComparator.AcceptNull toAccept;

    public BetweenCompare(SnfComparator.AcceptNull fromAccept, SnfComparator.AcceptNull toAccept) {
        this.fromAccept = fromAccept;
        this.toAccept = toAccept;
    }

    public boolean betweenInclusive(T from, T check, T to) {
        boolean result = this.compute(this.fromAccept.getComparator(), from, 1, check, this.toAccept.getComparator(), to, 0);
        return result;
    }

    public boolean compute(Comparator<T> fromComparator, T from, int fromInclusive, T check, Comparator<T> toComparator, T to, int toInclusive) {
        boolean fromNull = this.fromAccept.checkNull(Arrays.asList(from, check));
        boolean toNull = this.toAccept.checkNull(Arrays.asList(check, to));
        Supplier<Boolean> computedResult = () -> {
            boolean f = fromComparator.compare(from, check) < fromInclusive;
            boolean t = toComparator.compare(to, check) >= toInclusive;
            boolean result = f && t;
            return result;
        };
        boolean result = fromNull && toNull && computedResult.get() != false;
        return result;
    }

    public boolean between(T fromInclusive, T check, T toExclusive) {
        boolean result = this.compute(this.fromAccept.getComparator(), fromInclusive, 1, check, this.toAccept.getComparator(), toExclusive, 1);
        return result;
    }

    public boolean betweenNullLow(T fromInclusive, T check, T toInclusive) {
        boolean result = this.compute(this.fromAccept.getComparator(), fromInclusive, 1, check, SnfComparator.nullLow(), toInclusive, 0);
        return result;
    }

    public static <T extends Comparable<T>> BetweenCompare<T> of() {
        return new BetweenCompare<T>(SnfComparator.AcceptNull.FALSE_ON_NULL, SnfComparator.AcceptNull.FALSE_ON_NULL);
    }

    public static <T extends Comparable<T>> BetweenCompare<T> snfOf() {
        return new BetweenCompare<T>(SnfComparator.AcceptNull.COMPUTE_NULL_AS_LOW, SnfComparator.AcceptNull.COMPUTE_NULL_AS_HIGH);
    }

    public static <T extends Comparable<T>> BetweenCompare<T> of(SnfComparator.AcceptNull from, SnfComparator.AcceptNull to) {
        return new BetweenCompare<T>(from, to);
    }
}

