/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.lego;

import java.util.function.Supplier;

public class SnfCache {
    public static <T> SupplierCache<T> of(Supplier<T> refresher) {
        return new SupplierCache<T>(refresher);
    }

    public static <T> Reference<T> ofReference(T val) {
        return new Reference<T>(val);
    }

    public static <T> Reference<T> of() {
        return SnfCache.ofReference(null);
    }

    public static class SupplierCache<T>
    implements Supplier<T> {
        private boolean init = false;
        private T result;
        private final Supplier<T> refresher;

        public SupplierCache(Supplier<T> refresher) {
            this.refresher = refresher;
        }

        public T refresh() {
            this.result = this.refresher.get();
            this.init = true;
            return this.result;
        }

        @Override
        public T get() {
            T value = this.result;
            if (!this.init) {
                value = this.refresh();
            }
            return value;
        }

        public String toString() {
            return "SupplierCache [result=" + this.result + "]";
        }
    }

    public static class Reference<T>
    implements Supplier<T> {
        private T value;

        public Reference() {
            this(null);
        }

        public Reference(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        public void set(T val) {
            this.value = val;
        }
    }
}

