/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.component.r2.logic.nursing;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.component.r2.logic.nursing.BscpLogic;
import gov.cms.grouper.snf.lego.SnfComparator;
import gov.cms.grouper.snf.lego.SnfDataVersionImpl;
import gov.cms.grouper.snf.model.enums.NursingCmg;
import gov.cms.grouper.snf.util.ClaimInfo;

public class ReducedPhysicalFunctionLogic
extends SnfDataVersionImpl<NursingCmg> {
    private final BscpLogic bscp;
    private final ClaimInfo claim;

    public ReducedPhysicalFunctionLogic(ClaimInfo claim, BscpLogic bscp) {
        super(claim.getDataVersion());
        this.claim = claim;
        this.bscp = bscp;
    }

    public NursingCmg step3(int restorativeNursingCount) {
        int functionScore = this.claim.getFunctionScore();
        NursingCmg cmg = null;
        if (SnfComparator.betweenInclusive(0, functionScore, 5) && restorativeNursingCount >= 2) {
            cmg = NursingCmg.PDE2;
        } else if (SnfComparator.betweenInclusive(0, functionScore, 5) && SnfComparator.betweenInclusive(0, restorativeNursingCount, 1)) {
            cmg = NursingCmg.PDE1;
        } else if (SnfComparator.betweenInclusive(6, functionScore, 14) && restorativeNursingCount >= 2) {
            cmg = NursingCmg.PBC2;
        } else if (SnfComparator.betweenInclusive(15, functionScore, 16) && restorativeNursingCount >= 2) {
            cmg = NursingCmg.PA2;
        } else if (SnfComparator.betweenInclusive(6, functionScore, 14) && SnfComparator.betweenInclusive(0, restorativeNursingCount, 1)) {
            cmg = NursingCmg.PBC1;
        } else if (SnfComparator.betweenInclusive(15, functionScore, 16) && SnfComparator.betweenInclusive(0, restorativeNursingCount, 1)) {
            cmg = NursingCmg.PA1;
        }
        return SnfContext.trace(cmg);
    }

    @Override
    public NursingCmg exec() {
        int restorativeNursingCount = this.bscp.step5();
        NursingCmg cmg = this.step3(restorativeNursingCount);
        return SnfContext.trace(cmg);
    }
}

