/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.lego;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public abstract class CsvBuilder<T> {
    private final Map<Integer, BiConsumer<T, String>> csvMappings;
    private final Supplier<T> newModelSupplier;

    protected CsvBuilder(Supplier<T> modelSupplier, Map<Integer, BiConsumer<T, String>> csvMappings) {
        this.csvMappings = csvMappings;
        this.newModelSupplier = modelSupplier;
    }

    public T get(String[] row) {
        T item = this.newModelSupplier.get();
        for (Map.Entry<Integer, BiConsumer<T, String>> entry : this.csvMappings.entrySet()) {
            int index = entry.getKey();
            BiConsumer<T, String> exec = entry.getValue();
            String input = row[index];
            exec.accept(item, input);
        }
        return item;
    }
}

