/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model;

import java.util.HashMap;
import java.util.Map;

public enum CognitiveLevel {
    COGNITIVELY_INTACT("Cognitively Intact"),
    MILDLY_IMPAIRED("Mildly Impaired"),
    MODERATELY_IMPAIRED("Moderately Impaired"),
    SEVERELY_IMPARED("Severely Impaired");

    private static final Map<String, CognitiveLevel> map;
    private final String description;

    private CognitiveLevel(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static CognitiveLevel of(String key) {
        if (map.isEmpty()) {
            for (CognitiveLevel l : CognitiveLevel.values()) {
                map.put(l.getDescription(), l);
            }
        }
        CognitiveLevel level = map.get(key);
        return level;
    }

    static {
        map = new HashMap<String, CognitiveLevel>();
    }
}

