/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model;

import java.util.HashMap;
import java.util.Map;

public enum PdxEligibility {
    ORTHOPEDIC_SURGERY("May be Eligible for One of the Two Orthopedic Surgery Categories"),
    NON_ORTHOPEDIC_SURGERY("May be Eligible for the Non-Orthopedic Surgery Category"),
    NOT_ELIGIBLE("N/A");

    private static final Map<String, PdxEligibility> cache;
    private String description;

    private PdxEligibility(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static PdxEligibility of(String description) {
        if (cache.isEmpty()) {
            for (PdxEligibility eligibility : PdxEligibility.values()) {
                cache.put(eligibility.getDescription(), eligibility);
            }
        }
        return cache.get(description);
    }

    static {
        cache = new HashMap<String, PdxEligibility>();
    }
}

