/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.lego.CsvBuilder;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.model.table.BasicRow;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class SlpCmgRow
extends BasicRow {
    private String cmg;
    private Integer presenceOfAncSlCi;
    private Integer mechAltDietOrSwallowDisorder;

    private SlpCmgRow() {
        this(null, null, null);
    }

    public SlpCmgRow(String cmg, Integer presenceOfAncSlCi, Integer mechAltDietOrSwallowDisorder) {
        this.cmg = cmg;
        this.presenceOfAncSlCi = presenceOfAncSlCi;
        this.mechAltDietOrSwallowDisorder = mechAltDietOrSwallowDisorder;
    }

    public String getCmg() {
        return this.cmg;
    }

    public Integer getPresenceOfAncSlCi() {
        return this.presenceOfAncSlCi;
    }

    public Integer getMechAltDietOrSwallowDisorder() {
        return this.mechAltDietOrSwallowDisorder;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = super.getHashCode(result, 31);
        result = 31 * result + (this.cmg == null ? 0 : this.cmg.hashCode());
        result = 31 * result + (this.mechAltDietOrSwallowDisorder == null ? 0 : this.mechAltDietOrSwallowDisorder.hashCode());
        result = 31 * result + (this.presenceOfAncSlCi == null ? 0 : this.presenceOfAncSlCi.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SlpCmgRow other = (SlpCmgRow)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.cmg == null ? other.cmg != null : !this.cmg.equals(other.cmg)) {
            return false;
        }
        if (this.mechAltDietOrSwallowDisorder == null ? other.mechAltDietOrSwallowDisorder != null : !this.mechAltDietOrSwallowDisorder.equals(other.mechAltDietOrSwallowDisorder)) {
            return false;
        }
        return !(this.presenceOfAncSlCi == null ? other.presenceOfAncSlCi != null : !this.presenceOfAncSlCi.equals(other.presenceOfAncSlCi));
    }

    public static class Builder
    extends CsvBuilder<SlpCmgRow> {
        private static final BiConsumer<SlpCmgRow, String> presenceOfAncSlCi = (row, str) -> SlpCmgRow.access$302(row, SnfUtils.parse(str, null));
        private static final BiConsumer<SlpCmgRow, String> mechAltDietOrSwallowDisorder = (row, str) -> SlpCmgRow.access$202(row, SnfUtils.parse(str, null));
        private static final BiConsumer<SlpCmgRow, String> cmg = (row, str) -> SlpCmgRow.access$102(row, SnfUtils.clean(str));
        private static final Builder singleton = new Builder();

        public static Map<Integer, BiConsumer<SlpCmgRow, String>> initCsvMapping() {
            HashMap<Integer, BiConsumer<SlpCmgRow, String>> result = new HashMap<Integer, BiConsumer<SlpCmgRow, String>>();
            result.put(0, presenceOfAncSlCi);
            result.put(1, (BiConsumer<SlpCmgRow, String>)SnfUtils.cast(BasicRow.getLowVersionParser()));
            result.put(2, (BiConsumer<SlpCmgRow, String>)SnfUtils.cast(BasicRow.getHighVersionParser()));
            result.put(3, mechAltDietOrSwallowDisorder);
            result.put(4, cmg);
            return Collections.unmodifiableMap(result);
        }

        private Builder() {
            super(() -> new SlpCmgRow(), Builder.initCsvMapping());
        }

        public static Builder of() {
            return singleton;
        }
    }
}

