/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.lego.CsvBuilder;
import gov.cms.grouper.snf.lego.SnfUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class SnfVersionRow {
    private Integer internalVersion;
    private LocalDate from;
    private LocalDate to;
    private String version;

    private SnfVersionRow() {
        this(null, null, null, null);
    }

    public SnfVersionRow(Integer internalVersion, LocalDate from, LocalDate to, String version) {
        this.internalVersion = internalVersion;
        this.from = from;
        this.to = to;
        this.version = version;
    }

    public Integer getInternalVersion() {
        return this.internalVersion;
    }

    public LocalDate getFrom() {
        return this.from;
    }

    public LocalDate getTo() {
        return this.to;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        result = 31 * result + (this.internalVersion == null ? 0 : this.internalVersion.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnfVersionRow other = (SnfVersionRow)obj;
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.to == null ? other.to != null : !this.to.equals(other.to)) {
            return false;
        }
        if (this.internalVersion == null ? other.internalVersion != null : !this.internalVersion.equals(other.internalVersion)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public static class Builder
    extends CsvBuilder<SnfVersionRow> {
        private static final DateTimeFormatter formatter = DateTimeFormatter.BASIC_ISO_DATE;
        private static final BiConsumer<SnfVersionRow, String> internalVersion = (row, str) -> SnfVersionRow.access$402(row, SnfUtils.parse(str, null));
        private static final BiConsumer<SnfVersionRow, String> from = (row, str) -> SnfVersionRow.access$302(row, SnfUtils.parseDate(Builder.formatter, str));
        private static final BiConsumer<SnfVersionRow, String> to = (row, str) -> SnfVersionRow.access$202(row, SnfUtils.parseDate(Builder.formatter, str));
        private static final BiConsumer<SnfVersionRow, String> version = (row, str) -> SnfVersionRow.access$102(row, str);
        private static final Builder singleton = new Builder();

        private Builder() {
            super(() -> new SnfVersionRow(), Builder.initCsvMapping());
        }

        public static Map<Integer, BiConsumer<SnfVersionRow, String>> initCsvMapping() {
            HashMap<Integer, BiConsumer<SnfVersionRow, String>> result = new HashMap<Integer, BiConsumer<SnfVersionRow, String>>();
            result.put(0, internalVersion);
            result.put(1, from);
            result.put(2, to);
            result.put(3, version);
            return Collections.unmodifiableMap(result);
        }

        public static Builder of() {
            return singleton;
        }
    }
}

