/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.utility;

import gov.cms.utility.Row;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class DataConstruct {
    public List<? extends Row> loadTable(Class<? extends Row> rowClass, String filePath) throws IllegalAccessException, InstantiationException {
        Row row = rowClass.newInstance();
        List<Map<String, String>> rawContent = this.readContent(filePath, row.getHeaders().toArray(new String[0]));
        ArrayList<Row> table = new ArrayList<Row>();
        for (Map<String, String> rawRow : rawContent) {
            Row rowObject = rowClass.newInstance();
            rowObject.assign(rawRow);
            table.add(rowObject);
        }
        return table;
    }

    public List<Map<String, String>> readContent(String filepath, String[] headers) {
        ArrayList<Map<String, String>> content = new ArrayList<Map<String, String>>();
        InputStream in = this.getClass().getResourceAsStream(filepath);
        Scanner scanner = new Scanner(in);
        scanner.nextLine();
        while (scanner.hasNext()) {
            String line = scanner.nextLine();
            String csvRegex = ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
            String[] fields = line.split(csvRegex, -1);
            HashMap<String, String> row = new HashMap<String, String>();
            for (int index = 0; index < fields.length; ++index) {
                row.put(headers[index], fields[index].replaceAll("\"", ""));
            }
            content.add(row);
        }
        return content;
    }
}

