/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.util.reader;

import com.mmm.his.cer.foundation.model.ICode;
import gov.cms.grouper.snf.app.Pdpm;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.AssessmentType;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import gov.cms.grouper.snf.model.SnfError;
import gov.cms.grouper.snf.model.reader.AssessmentItem;
import gov.cms.grouper.snf.model.reader.Rai300;
import gov.cms.grouper.snf.transfer.SnfClaim;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class SnfDataMapper {
    public SnfClaim mapMdsToClaim(String utfRecord, AssessmentItem[] items) {
        SnfClaim claim = new SnfClaim();
        claim.setOriginalRecord(utfRecord);
        if (utfRecord.length() < 3688) {
            claim.addErrors(SnfError.INVALID_LINE_LENGTH.getReason(utfRecord.length() + ""));
        }
        for (AssessmentItem item : items) {
            int index = item.getIndex() - 1;
            String itemValue = utfRecord.substring(index, index + item.getLength());
            if (item.getAssessmentType() == AssessmentType.ARD) {
                try {
                    claim.setAssessmentReferenceDate(LocalDate.parse(itemValue, DateTimeFormatter.BASIC_ISO_DATE));
                }
                catch (DateTimeParseException e) {
                    claim.addErrors(SnfError.INVALID_ASSESSMENT_REFERENCE_DATE.getReason(itemValue));
                }
                continue;
            }
            if (item.getAssessmentType() == AssessmentType.PDX) {
                claim.insertPrimaryDiagnosis(new SnfDiagnosisCode(itemValue, null, null, null));
                continue;
            }
            if (item.getAssessmentType() == AssessmentType.SERVICES) {
                if (SnfUtils.trimICDCodes(itemValue).isEmpty()) continue;
                claim.addCode((ICode)new SnfDiagnosisCode(itemValue, null, null, null));
                continue;
            }
            if (item.getAssessmentType() == AssessmentType.PPS) {
                int value = SnfUtils.parse(itemValue, Integer.MIN_VALUE);
                if (value == 8) {
                    claim.setAiCode(0);
                    continue;
                }
                if (value == 1) {
                    claim.setAiCode(1);
                    continue;
                }
                if (value != 99) continue;
                claim.setAiCode(null);
                continue;
            }
            if (item.getAssessmentType() == AssessmentType.OBRA) {
                int value = SnfUtils.parse(itemValue, Integer.MIN_VALUE);
                if (Rai300.A0310A.getValidValues().contains(value)) {
                    claim.setObra(value);
                    continue;
                }
                Pdpm.log.warn("Invalid value for A0310A");
                continue;
            }
            Assessment assessment = new Assessment(item.name(), item.getXmlTag(), itemValue);
            claim.addAssessment(assessment);
        }
        return claim;
    }

    public String mapClaimToMds(SnfClaim claim, AssessmentItem[] items) {
        String hippsCode = claim.hasError() ? "       " : claim.getHippsCode();
        StringBuilder record = new StringBuilder(claim.getOriginalRecord());
        int hippsIndex = Rai300.RECALCULATED_Z0100A.getIndex() - 1;
        record.replace(hippsIndex, hippsIndex + hippsCode.length(), hippsCode);
        int versionIndex = Rai300.RECALCULATED_Z0100B.getIndex() - 1;
        String version = claim.getRecalculated_z0100b();
        record.replace(versionIndex, versionIndex + version.length(), version);
        return record.toString();
    }
}

