package gov.cms.grouper.snf.lego;

public class Triple<ONET, TWOT, THREET> {
  private final ONET one;
  private final TWOT two;
  private final THREET three;

  public Triple(ONET one, TWOT two, THREET three) {
    super();
    this.one = one;
    this.two = two;
    this.three = three;
  }

  public ONET getOne() {
    return this.one;
  }

  public TWOT getTwo() {
    return this.two;
  }

  public THREET getThree() {
    return this.three;
  }

  public static <ONET, TWOT, THREET> Triple<ONET, TWOT, THREET> of(ONET one, TWOT two,
      THREET three) {
    return new Triple<>(one, two, three);
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.one == null) ? 0 : this.one.hashCode());
    result = prime * result + ((this.three == null) ? 0 : this.three.hashCode());
    result = prime * result + ((this.two == null) ? 0 : this.two.hashCode());
    return result;
  }

  @SuppressWarnings("rawtypes")
  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (this.getClass() != obj.getClass()) {
      return false;
    }
    Triple other = (Triple) obj;
    if (this.one == null) {
      if (other.one != null) {
        return false;
      }
    } else if (!this.one.equals(other.one)) {
      return false;
    }
    if (this.three == null) {
      if (other.three != null) {
        return false;
      }
    } else if (!this.three.equals(other.three)) {
      return false;
    }
    if (this.two == null) {
      if (other.two != null) {
        return false;
      }
    } else if (!this.two.equals(other.two)) {
      return false;
    }
    return true;
  }

}
