package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.lego.CsvBuilder;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.model.PdxEligibility;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class DiagnosisMasterRow extends BasicRow {
  private String code;
  private String clinicalCategory;
  private String slpCategory;
  private String ntaCategory;
  private PdxEligibility pdxEligibility;

  private DiagnosisMasterRow() {}

  public DiagnosisMasterRow(String code, String clinicalCategory, String slpCategory,
      String ntaCategory, PdxEligibility pdxEligibility) {
    this.code = code;
    this.clinicalCategory = clinicalCategory;
    this.slpCategory = slpCategory;
    this.ntaCategory = ntaCategory;
    this.pdxEligibility = pdxEligibility;
  }

  public String getCode() {
    return this.code;
  }

  public String getClinicalCategory() {
    return this.clinicalCategory;
  }

  public String getSlpCategory() {
    return this.slpCategory;
  }

  public String getNtaCategory() {
    return this.ntaCategory;
  }

  public PdxEligibility getPdxEligibility() {
    return this.pdxEligibility;
  }

  public SnfDiagnosisCode of() {
    SnfDiagnosisCode snfDiagnosisCode =
        new SnfDiagnosisCode(this.code, clinicalCategory, slpCategory, ntaCategory);
    return snfDiagnosisCode;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result =
        prime * result + ((this.clinicalCategory == null) ? 0 : this.clinicalCategory.hashCode());
    result = prime * result + ((this.code == null) ? 0 : this.code.hashCode());
    result = prime * result + ((this.ntaCategory == null) ? 0 : this.ntaCategory.hashCode());
    result = prime * result + ((this.slpCategory == null) ? 0 : this.slpCategory.hashCode());
    result = prime * result + ((this.pdxEligibility == null) ? 0 : this.pdxEligibility.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (this.getClass() != obj.getClass()) {
      return false;
    }
    DiagnosisMasterRow other = (DiagnosisMasterRow) obj;
    if (!super.equals(other)) {
      return false;
    }

    if (this.clinicalCategory == null) {
      if (other.clinicalCategory != null) {
        return false;
      }
    } else if (!this.clinicalCategory.equals(other.clinicalCategory)) {
      return false;
    }
    if (this.code == null) {
      if (other.code != null) {
        return false;
      }
    } else if (!this.code.equals(other.code)) {
      return false;
    }
    if (this.ntaCategory == null) {
      if (other.ntaCategory != null) {
        return false;
      }
    } else if (!this.ntaCategory.equals(other.ntaCategory)) {
      return false;
    }
    if (this.slpCategory == null) {
      if (other.slpCategory != null) {
        return false;
      }
    } else if (!this.slpCategory.equals(other.slpCategory)) {
      return false;
    }
    if (this.pdxEligibility == null) {
      if (other.pdxEligibility != null) {
        return false;
      }
    } else if (this.pdxEligibility != other.pdxEligibility) {
      return false;
    }
    return true;
  }

  public static class Builder extends CsvBuilder<DiagnosisMasterRow> {

    private static final BiConsumer<DiagnosisMasterRow, String> code =
        (modelRow, value) -> modelRow.code = SnfUtils.clean(value);

    private static final BiConsumer<DiagnosisMasterRow, String> clinicalCategory =
        (modelRow, value) -> modelRow.clinicalCategory = SnfUtils.clean(value);

    private static final BiConsumer<DiagnosisMasterRow, String> slpCategory =
        (modelRow, value) -> modelRow.slpCategory = SnfUtils.clean(value);

    private static final BiConsumer<DiagnosisMasterRow, String> ntaCategory =
        (modelRow, value) -> modelRow.ntaCategory = SnfUtils.clean(value);

    private static final BiConsumer<DiagnosisMasterRow, String> pdxEligibility =
        (modelRow, value) -> modelRow.pdxEligibility = PdxEligibility.of(value);

    private static final Builder singleton = new Builder();

    public static Map<Integer, BiConsumer<DiagnosisMasterRow, String>> initCsvMapping() {
      Map<Integer, BiConsumer<DiagnosisMasterRow, String>> result = new HashMap<>();
      result.put(0, Builder.code);
      result.put(1, BasicRow.getLowVersionParser());
      result.put(2, BasicRow.getHighVersionParser());
      result.put(3, Builder.clinicalCategory);
      result.put(4, Builder.slpCategory);
      result.put(5, Builder.ntaCategory);
      result.put(6, Builder.pdxEligibility);

      return Collections.unmodifiableMap(result);
    }

    private Builder() {
      super(DiagnosisMasterRow::new, Builder.initCsvMapping());
    }

    public static Builder of() {
      return Builder.singleton;
    }

  }
}
