package gov.cms.grouper.snf.lego;

/**
 * Base implementation for each Logic class.
 *
 * @param <T> The data type that ultimately gets return by the Logic class. This can either be a CMG
 *        String, CognitivieLevel, etc.
 */
public abstract class SnfDataVersionImpl<T> {

  private final int dataVersion;

  public SnfDataVersionImpl(int dataVersion) {
    super();
    this.dataVersion = dataVersion;
  }

  public int getDataVersion() {
    return this.dataVersion;
  }

  public abstract T exec();

}
