package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.lego.CsvBuilder;
import gov.cms.grouper.snf.lego.SnfUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class PerformanceRecodeRow extends BasicRow {
  private Integer performanceScore;
  private Integer functionScore;

  private PerformanceRecodeRow() {
    this(null, null);
  }

  public PerformanceRecodeRow(Integer performanceScore, Integer functionScore) {
    super();
    this.performanceScore = performanceScore;
    this.functionScore = functionScore;
  }

  public Integer getPerformanceScore() {
    return this.performanceScore;
  }

  public Integer getFunctionScore() {
    return this.functionScore;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result = prime * result + ((this.functionScore == null) ? 0 : this.functionScore.hashCode());
    result =
        prime * result + ((this.performanceScore == null) ? 0 : this.performanceScore.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (this.getClass() != obj.getClass()) {
      return false;
    }
    PerformanceRecodeRow other = (PerformanceRecodeRow) obj;
    if (super.equals(other) == false) {
      return false;
    }

    if (this.functionScore == null) {
      if (other.functionScore != null) {
        return false;
      }
    } else if (!this.functionScore.equals(other.functionScore)) {
      return false;
    }
    if (this.performanceScore == null) {
      if (other.performanceScore != null) {
        return false;
      }
    } else if (!this.performanceScore.equals(other.performanceScore)) {
      return false;
    }
    return true;
  }

  public static class Builder extends CsvBuilder<PerformanceRecodeRow> {

    private static final BiConsumer<PerformanceRecodeRow, String> pScore =
        (row, str) -> row.performanceScore = SnfUtils.parse(str, null);

    private static final BiConsumer<PerformanceRecodeRow, String> fScore =
        (row, str) -> row.functionScore = SnfUtils.parse(str, null);

    private static final PerformanceRecodeRow.Builder singleton =
        new PerformanceRecodeRow.Builder();

    public static Map<Integer, BiConsumer<PerformanceRecodeRow, String>> initCsvMapping() {
      Map<Integer, BiConsumer<PerformanceRecodeRow, String>> result = new HashMap<>();
      result.put(0, PerformanceRecodeRow.Builder.pScore);
      result.put(1, SnfUtils.cast(BasicRow.getLowVersionParser()));
      result.put(2, SnfUtils.cast(BasicRow.getHighVersionParser()));
      result.put(3, PerformanceRecodeRow.Builder.fScore);

      return Collections.unmodifiableMap(result);
    }

    private Builder() {
      super(PerformanceRecodeRow::new, PerformanceRecodeRow.Builder.initCsvMapping());
    }

    public static PerformanceRecodeRow.Builder of() {
      return PerformanceRecodeRow.Builder.singleton;
    }
  }
}
