package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.lego.CsvBuilder;
import gov.cms.grouper.snf.lego.SnfUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class SlpComorbiditiesRow extends BasicRow {

  public static final String I8000 = "I8000";

  private String mdsItem;
  private String category;

  private SlpComorbiditiesRow() {
    this(null, null);
  }

  public SlpComorbiditiesRow(String mdsItem, String category) {
    super();
    this.mdsItem = mdsItem;
    this.category = category;
  }

  public String getMdsItem() {
    return this.mdsItem;
  }

  public String getCategory() {
    return this.category;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result = prime * result + ((this.category == null) ? 0 : this.category.hashCode());
    result = prime * result + ((this.mdsItem == null) ? 0 : this.mdsItem.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (this.getClass() != obj.getClass()) {
      return false;
    }
    SlpComorbiditiesRow other = (SlpComorbiditiesRow) obj;
    if (super.equals(other) == false) {
      return false;
    }

    if (this.category == null) {
      if (other.category != null) {
        return false;
      }
    } else if (!this.category.equals(other.category)) {
      return false;
    }
    if (this.mdsItem == null) {
      if (other.mdsItem != null) {
        return false;
      }
    } else if (!this.mdsItem.equals(other.mdsItem)) {
      return false;
    }
    return true;
  }

  public static class Builder extends CsvBuilder<SlpComorbiditiesRow> {
    private static final BiConsumer<SlpComorbiditiesRow, String> mdsItem =
        (row, str) -> row.mdsItem = SnfUtils.clean(str);
    private static final BiConsumer<SlpComorbiditiesRow, String> category =
        (row, str) -> row.category = SnfUtils.clean(str);

    private Builder() {
      super(SlpComorbiditiesRow::new, SlpComorbiditiesRow.Builder.initCsvMapping());
    }

    private static Map<Integer, BiConsumer<SlpComorbiditiesRow, String>> initCsvMapping() {
      Map<Integer, BiConsumer<SlpComorbiditiesRow, String>> result = new HashMap<>();
      result.put(0, SlpComorbiditiesRow.Builder.mdsItem);
      result.put(1, SnfUtils.cast(BasicRow.getLowVersionParser()));
      result.put(2, SnfUtils.cast(BasicRow.getHighVersionParser()));
      result.put(3, SlpComorbiditiesRow.Builder.category);

      return Collections.unmodifiableMap(result);
    }

    private static final SlpComorbiditiesRow.Builder singleton = new SlpComorbiditiesRow.Builder();

    public static SlpComorbiditiesRow.Builder of() {
      return SlpComorbiditiesRow.Builder.singleton;
    }
  }
}
