/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf;

import gov.cms.grouper.snf.lego.CsvHelper;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.model.CognitiveLevel;
import gov.cms.grouper.snf.model.table.BasicRow;
import gov.cms.grouper.snf.model.table.ClinicalCategoryMappingRow;
import gov.cms.grouper.snf.model.table.CmgForPtOtRow;
import gov.cms.grouper.snf.model.table.CognitiveLevelRow;
import gov.cms.grouper.snf.model.table.DiagnosisMasterRow;
import gov.cms.grouper.snf.model.table.NtaCmgRow;
import gov.cms.grouper.snf.model.table.NtaComorbidityRow;
import gov.cms.grouper.snf.model.table.PerformanceRecodeRow;
import gov.cms.grouper.snf.model.table.SlpCmgRow;
import gov.cms.grouper.snf.model.table.SlpComorbiditiesRow;
import gov.cms.grouper.snf.model.table.SnfVersionRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SnfTables {
    public static final Map<Integer, SnfVersionRow> versions = SnfTables.initVersions();
    public static final Map<String, Set<ClinicalCategoryMappingRow>> clinicalCategoryMapping = SnfTables.initMap("specTableCSV/CLINICAL_CATEGORY_MAPPINGS.csv", lines -> CsvHelper.of(lines, ClinicalCategoryMappingRow.Builder.of(), true), ClinicalCategoryMappingRow::getPdsClinicalCategory, versions);
    public static final Map<CognitiveLevel, Set<CognitiveLevelRow>> cognitiveLeveltable = SnfTables.initMap("specTableCSV/CALC_OF_PDPM_LVL_FROM_BIMS.csv", filePath -> CsvHelper.of(filePath, CognitiveLevelRow.Builder.of(), true), CognitiveLevelRow::getCognitiveLevel, versions);
    public static final Map<String, Set<CmgForPtOtRow>> cmgForPtOt = SnfTables.initMap("specTableCSV/CMG_FOR_PT_OT.csv", filePath -> CsvHelper.of(filePath, CmgForPtOtRow.Builder.of(), true), CmgForPtOtRow::getClinicalCategory, versions);
    public static final Map<String, Set<NtaCmgRow>> ntaCmgTable = SnfTables.initMap("specTableCSV/NTA_CMG.csv", filePath -> CsvHelper.of(filePath, NtaCmgRow.Builder.of(), true), NtaCmgRow::getCmg, versions);
    public static final Map<String, Set<NtaComorbidityRow>> ntaComorbidityTableByConditionOfService = SnfTables.initMap("specTableCSV/NTA_COMORBIDITY_SCORE_CALC.csv", filePath -> CsvHelper.of(filePath, NtaComorbidityRow.Builder.of(), true), NtaComorbidityRow::getConditionService, versions);
    public static final Map<String, Set<DiagnosisMasterRow>> diagnosisMasterTable = SnfTables.initMap("specTableCSV/DIAGNOSIS_MASTER.csv", filePath -> CsvHelper.of(filePath, DiagnosisMasterRow.Builder.of(), true), DiagnosisMasterRow::getCode, versions);
    public static final Map<Integer, Set<PerformanceRecodeRow>> performanceRecodeTable = SnfTables.initMap("specTableCSV/PERFORMANCE_RECODE.csv", filePath -> CsvHelper.of(filePath, PerformanceRecodeRow.Builder.of(), true), PerformanceRecodeRow::getPerformanceScore, versions);
    public static final Map<Integer, Set<SlpCmgRow>> slpCmgTable = SnfTables.initMap("specTableCSV/SLP_CMG.csv", filePath -> CsvHelper.of(filePath, SlpCmgRow.Builder.of(), true), SlpCmgRow::getPresenceOfAncSlCi, versions);
    public static final Map<String, Set<SlpComorbiditiesRow>> slpComorbiditiesTable = SnfTables.initMap("specTableCSV/SLP_COMORBIDITIES.csv", filePath -> CsvHelper.of(filePath, SlpComorbiditiesRow.Builder.of(), true), SlpComorbiditiesRow::getMdsItem, versions);

    private static Map<Integer, SnfVersionRow> initVersions() {
        List lines = SnfUtils.doOrDie(() -> SnfUtils.readFileFromClassPath("specTableCSV/VERSION.csv"));
        CsvHelper<SnfVersionRow> helper = new CsvHelper<SnfVersionRow>(lines, SnfVersionRow.Builder.of(), true);
        Set<SnfVersionRow> items = helper.load();
        HashMap<Integer, SnfVersionRow> map = new HashMap<Integer, SnfVersionRow>();
        for (SnfVersionRow item : items) {
            map.put(item.getInternalVersion(), item);
        }
        return Collections.unmodifiableMap(map);
    }

    public static String getRecalculatedZ0100B() {
        String recalculatedZ0100B = "";
        Integer tmp = Integer.MIN_VALUE;
        for (Integer version : versions.keySet()) {
            if (version <= tmp) continue;
            tmp = version;
            recalculatedZ0100B = versions.get(version).getVersion();
        }
        return recalculatedZ0100B.substring(1);
    }

    protected static <KEY, T extends BasicRow> Map<KEY, Set<T>> initMap(Supplier<Set<T>> loader, Function<T, KEY> keyFunc, Map<Integer, SnfVersionRow> versionsTable) {
        Set<T> items = loader.get();
        for (BasicRow item : items) {
            item.populateVersion(versionsTable);
        }
        Supplier<Set> newCollection = () -> new HashSet();
        Map<KEY, Set> unmodifiableMap = SnfUtils.groupBy((Function)SnfUtils.cast(SnfUtils.makeImmutableSet), items, keyFunc, newCollection);
        return unmodifiableMap;
    }

    private static <KEY, T extends BasicRow> Map<KEY, Set<T>> initMap(String filePath, Function<List<String>, CsvHelper<T>> helperFunc, Function<T, KEY> keyFunc, Map<Integer, SnfVersionRow> versionsTable) {
        Supplier<Set<T>> loader = () -> {
            List lines = SnfUtils.doOrDie(() -> SnfUtils.readFileFromClassPath(filePath));
            CsvHelper helper = (CsvHelper)helperFunc.apply(lines);
            Set items = helper.load();
            return items;
        };
        return SnfTables.initMap(loader, keyFunc, versionsTable);
    }

    public static <KEY, T extends BasicRow, CHECK> T get(Map<KEY, Set<T>> defMap, KEY key, BiFunction<T, CHECK, Boolean> selector, CHECK value) {
        Set items = defMap.get(key);
        BasicRow result = SnfUtils.nullCheck2(items, null, () -> items.stream().filter(item -> (Boolean)selector.apply(item, value)).findFirst().orElse(null));
        return (T)result;
    }

    public static <KEY, T extends BasicRow, CHECK> Set<T> getAll(Map<KEY, Set<T>> defMap, KEY key, BiFunction<T, CHECK, Boolean> selector, CHECK value) {
        Set items = defMap.get(key);
        Set result = SnfUtils.nullCheck2(items, null, () -> items.stream().filter(item -> (Boolean)selector.apply(item, value)).collect(Collectors.toSet()));
        return result;
    }

    public static <KEY, T extends BasicRow, OUT> List<OUT> selectAll(Map<KEY, Set<T>> defMap, Predicate<T> condition, Function<T, OUT> transformer) {
        ArrayList<OUT> results = new ArrayList<OUT>(20);
        for (Set<T> set : defMap.values()) {
            for (BasicRow item : set) {
                boolean cond = condition.test(item);
                if (!cond) continue;
                OUT out = transformer.apply(item);
                results.add(out);
            }
        }
        return results;
    }

    public static <KEY, T extends BasicRow, CHECK> T get(Map<KEY, Set<T>> defMap, BiFunction<T, CHECK, Boolean> selector, CHECK value) {
        Set items = defMap.values().stream().flatMap(list -> list.stream()).collect(Collectors.toSet());
        BasicRow result = SnfUtils.nullCheck2(items, null, () -> items.stream().filter(item -> (Boolean)selector.apply(item, value)).findFirst().orElse(null));
        return (T)result;
    }
}

