/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.component.r2.logic.nursing;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.component.r2.logic.NursingLogic;
import gov.cms.grouper.snf.lego.SnfComparator;
import gov.cms.grouper.snf.lego.SnfDataVersionImpl;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.model.enums.NursingCmg;
import gov.cms.grouper.snf.model.reader.Rai300;
import gov.cms.grouper.snf.util.ClaimInfo;

public class SpecialCare
extends SnfDataVersionImpl<NursingCmg> {
    private final ClaimInfo claim;
    private final boolean classifiedTubeFeeding;
    private final int finalSkinTreatmentsCount;
    private final boolean radiation;
    private final boolean dialysis;
    private final boolean depressed;

    public SpecialCare(ClaimInfo claim) {
        super(claim.getDataVersion());
        this.claim = claim;
        this.finalSkinTreatmentsCount = this.getSkinTreatmentsCount();
        this.radiation = claim.isCheckedAndNotNull(Rai300.O0100B2);
        this.dialysis = claim.isCheckedAndNotNull(Rai300.O0100J2);
        this.classifiedTubeFeeding = this.isClassifiedTubeFeeding();
        this.depressed = this.isDepressed();
    }

    protected NursingCmg evaluateSpecialCareHigh() {
        boolean isSpecialCareHighApplicable = this.isSpecialCareHighApplicable();
        int functionScore = this.claim.getFunctionScore();
        NursingCmg result = null;
        if (isSpecialCareHighApplicable) {
            if (functionScore >= 15) {
                result = this.evaluateClinicallyComplex(true);
            }
            if (SnfComparator.betweenInclusive(0, functionScore, 5)) {
                result = this.depressed ? NursingCmg.HDE2 : NursingCmg.HDE1;
            } else if (functionScore >= 6 && functionScore <= 14) {
                result = this.depressed ? NursingCmg.HBC2 : NursingCmg.HBC1;
            }
        } else {
            result = this.evaluateSpecialCareLow();
        }
        return SnfContext.trace(result);
    }

    protected boolean isSpecialCareHighApplicable() {
        boolean comatose = this.isComatose();
        boolean septicemia = this.isSepticemia();
        boolean diabetes = this.isDiabetes();
        boolean quadriplegia = this.isQuadriplegia();
        boolean breathing = this.isBreathing();
        boolean parenteral = this.isParenteral();
        boolean sick = this.isSick();
        boolean respiratory = this.isRespiratory();
        boolean result = SnfUtils.any(comatose, septicemia, diabetes, quadriplegia, breathing, parenteral, sick, respiratory);
        return SnfContext.trace(result);
    }

    protected NursingCmg evaluateSpecialCareLow() {
        boolean isSpecialCareLowApplicable = this.isSpecialCareLowApplicable();
        int functionScore = this.claim.getFunctionScore();
        NursingCmg result = null;
        if (isSpecialCareLowApplicable) {
            if (functionScore >= 15) {
                result = this.evaluateClinicallyComplex(true);
            }
            if (functionScore >= 0 && functionScore <= 5) {
                result = this.depressed ? NursingCmg.LDE2 : NursingCmg.LDE1;
            } else if (functionScore >= 6 && functionScore <= 14) {
                result = this.depressed ? NursingCmg.LBC2 : NursingCmg.LBC1;
            }
        } else {
            result = this.evaluateClinicallyComplex(false);
        }
        return SnfContext.trace(result);
    }

    public boolean isSpecialCareLowApplicable() {
        boolean cerebralPalsy = this.isCerebralPalsy();
        boolean multiSclerosis = this.isMultiSclerosis();
        boolean parkinson = this.isParkinson();
        boolean respiratoryOxyTherapy = this.isRespiratoryOxyTherapy();
        boolean stage2Ulcer = this.isStage2Ulcer();
        boolean stage3Or4Ulcer = this.isStage3Or4Ulcer();
        boolean twoOrMoreVenousArterialUlcers = this.isTwoOrMoreVenousArterialUlcers();
        boolean stage2UlcerAndVenousArterialUlcer = this.isStage2UlcerAndVenousArterialUlcer();
        boolean foot = this.isFoot();
        boolean result = SnfUtils.any(cerebralPalsy, multiSclerosis, parkinson, respiratoryOxyTherapy, stage2Ulcer, stage3Or4Ulcer, twoOrMoreVenousArterialUlcers, stage2UlcerAndVenousArterialUlcer, foot, this.radiation, this.dialysis, this.classifiedTubeFeeding);
        return SnfContext.trace(result);
    }

    public NursingCmg evaluateClinicallyComplex(boolean forceClinicallyComplexApplicable) {
        int functionScore = this.claim.getFunctionScore();
        boolean isClinicallyComplexApplicable = forceClinicallyComplexApplicable || this.isClinicallyComplexApplicable();
        NursingCmg result = null;
        if (isClinicallyComplexApplicable) {
            if (functionScore >= 0 && functionScore <= 5) {
                result = this.depressed ? NursingCmg.CDE2 : NursingCmg.CDE1;
            } else if (functionScore >= 6 && functionScore <= 14) {
                result = this.depressed ? NursingCmg.CBC2 : NursingCmg.CBC1;
            } else if (functionScore >= 15 && functionScore <= 16) {
                result = this.depressed ? NursingCmg.CA2 : NursingCmg.CA1;
            }
        }
        return SnfContext.trace(result);
    }

    public boolean isClinicallyComplexApplicable() {
        int functionScore = this.claim.getFunctionScore();
        Boolean isPneumonia = this.claim.isCheckedAndNotNull(Rai300.I2000);
        Boolean isHemiplegiaOrHemiparesis = this.claim.isCheckedAndNotNull(Rai300.I4900) != false && functionScore <= 11;
        Boolean isOpenLesions = !(this.claim.isCheckedAndNotNull(Rai300.M1040D) == false && this.claim.isCheckedAndNotNull(Rai300.M1040E) == false || this.claim.isCheckedAndNotNull(Rai300.M1200F) == false && this.claim.isCheckedAndNotNull(Rai300.M1200G) == false && this.claim.isCheckedAndNotNull(Rai300.M1200H) == false);
        Boolean isBurnsSecondOrThirdDegree = this.claim.isCheckedAndNotNull(Rai300.M1040F);
        Boolean isChemotherapyWhileResident = this.claim.isCheckedAndNotNull(Rai300.O0100A2);
        Boolean isOxygenTherapyWhileResident = this.claim.isCheckedAndNotNull(Rai300.O0100C2);
        Boolean isIVMedicationsWhileResident = this.claim.isCheckedAndNotNull(Rai300.O0100H2);
        Boolean isTransfusionsWhileResident = this.claim.isCheckedAndNotNull(Rai300.O0100I2);
        boolean result = isPneumonia != false || isHemiplegiaOrHemiparesis != false || isOpenLesions != false || isBurnsSecondOrThirdDegree != false || isChemotherapyWhileResident != false || isOxygenTherapyWhileResident != false || isIVMedicationsWhileResident != false || isTransfusionsWhileResident != false;
        return SnfContext.trace(result);
    }

    public boolean isDepressed() {
        int d0300TotalSeverityScore = this.claim.getAssessmentValue(Rai300.D0300);
        int d0600TotalSeverityScore = this.claim.getAssessmentValue(Rai300.D0600);
        boolean result = d0300TotalSeverityScore >= 10 && d0300TotalSeverityScore != 99 || d0600TotalSeverityScore >= 10;
        return SnfContext.trace(result);
    }

    @Override
    public NursingCmg exec() {
        NursingCmg result = this.evaluateSpecialCareHigh();
        return SnfContext.trace(result);
    }

    public boolean isFoot() {
        boolean valuesPresent = this.claim.isAnyAssessmentValuesPresent(SnfUtils.toSet(Rai300.M1040A, Rai300.M1040B, Rai300.M1040C));
        boolean m1200i = this.claim.isCheckedAndNotNull(Rai300.M1200I);
        boolean result = valuesPresent && m1200i;
        return result;
    }

    public boolean isStage2UlcerAndVenousArterialUlcer() {
        boolean m1030 = this.claim.isCheckedAndNotNull(Rai300.M1030);
        boolean m0300b1 = this.claim.isCheckedAndNotNull(Rai300.M0300B1);
        boolean result = this.finalSkinTreatmentsCount >= 2 && m1030 && m0300b1;
        return result;
    }

    public boolean isTwoOrMoreVenousArterialUlcers() {
        boolean m1030 = this.claim.isAnyAssessmentValuesGreaterThanN(SnfUtils.toSet(Rai300.M1030), 1);
        boolean result = m1030 && this.finalSkinTreatmentsCount >= 2;
        return result;
    }

    public boolean isStage3Or4Ulcer() {
        boolean meet = this.claim.isAnyAssessmentValuesGreaterThanN(SnfUtils.toSet(Rai300.M0300C1, Rai300.M0300D1, Rai300.M0300F1), 0);
        boolean result = meet && this.finalSkinTreatmentsCount >= 2;
        return result;
    }

    public boolean isStage2Ulcer() {
        boolean m0300b1 = this.claim.isAnyAssessmentValuesGreaterThanN(SnfUtils.toSet(Rai300.M0300B1), 1);
        boolean result = m0300b1 && this.finalSkinTreatmentsCount >= 2;
        return result;
    }

    protected int getSkinTreatmentsCount() {
        int skinTreatmentsCount = this.claim.countAssessmentPresent(NursingLogic.skinTreatments);
        int skinTreatments2Count = this.claim.countAssessmentPresent(NursingLogic.skinTreatments2);
        if (skinTreatments2Count >= 1) {
            ++skinTreatmentsCount;
        }
        return skinTreatmentsCount;
    }

    public boolean isFeedingTube() {
        boolean present = this.claim.isAnyAssessmentValuesPresent(SnfUtils.toSet(Rai300.K0510B1, Rai300.K0510B2));
        boolean classifiedTubeFeeding = this.classifiedTubeFeeding;
        boolean result = present && classifiedTubeFeeding;
        return result;
    }

    public boolean isRespiratoryOxyTherapy() {
        boolean i6300 = this.claim.isCheckedAndNotNull(Rai300.I6300);
        boolean o0100c2 = this.claim.isCheckedAndNotNull(Rai300.O0100C2);
        boolean result = i6300 && o0100c2;
        return result;
    }

    public boolean isParkinson() {
        int functionScore = this.claim.getFunctionScore();
        boolean i5300 = this.claim.isCheckedAndNotNull(Rai300.I5300);
        boolean result = i5300 && functionScore <= 11;
        return result;
    }

    public boolean isMultiSclerosis() {
        boolean i5200 = this.claim.isCheckedAndNotNull(Rai300.I5200);
        int functionScore = this.claim.getFunctionScore();
        boolean result = i5200 && functionScore <= 11;
        return result;
    }

    public boolean isCerebralPalsy() {
        boolean i4400 = this.claim.isCheckedAndNotNull(Rai300.I4400);
        int functionScore = this.claim.getFunctionScore();
        boolean result = i4400 && functionScore <= 11;
        return result;
    }

    public boolean isRespiratory() {
        boolean result = this.claim.hasAssessmentOf(Rai300.O0400D2, item -> item.getValueInt() == 7);
        return result;
    }

    public boolean isSick() {
        boolean j1550a = this.claim.isCheckedAndNotNull(Rai300.J1550A);
        boolean hasK0300 = this.claim.hasAssessmentOf(Rai300.K0300, item -> SnfComparator.betweenInclusive(1, item.getValueInt(), 2));
        boolean anyPresentJ1550B$I2000 = this.claim.isAnyAssessmentValuesPresent(SnfUtils.toSet(Rai300.I2000, Rai300.J1550B));
        boolean anyPresentK0510B1$K0510B2 = this.claim.isAnyAssessmentValuesPresent(SnfUtils.toSet(Rai300.K0510B1, Rai300.K0510B2));
        boolean result = j1550a && (hasK0300 || anyPresentJ1550B$I2000 || anyPresentK0510B1$K0510B2 && this.classifiedTubeFeeding);
        return result;
    }

    public boolean isParenteral() {
        boolean result = this.claim.isAnyAssessmentValuesPresent(SnfUtils.toSet(Rai300.K0510A1, Rai300.K0510A2));
        return result;
    }

    protected boolean isClassifiedTubeFeeding() {
        boolean k0710a3Equals3 = this.claim.hasAssessmentOf(Rai300.K0710A3, item -> item.getValueInt() == 3);
        boolean k0710a3Equals2 = this.claim.hasAssessmentOf(Rai300.K0710A3, item -> item.getValueInt() == 2);
        boolean k0710b3 = this.claim.hasAssessmentOf(Rai300.K0710B3, item -> item.getValueInt() == 2);
        boolean result = k0710a3Equals3 || k0710a3Equals2 && k0710b3;
        return result;
    }

    public boolean isBreathing() {
        boolean result = this.claim.isCheckedAndNotNull(Rai300.I6200) != false && this.claim.isCheckedAndNotNull(Rai300.J1100C) != false;
        return result;
    }

    public boolean isComatose() {
        boolean result = this.claim.isComaAndNoActivities(() -> this.claim.getAssessmentValue(Rai300.B0100));
        return result;
    }

    public boolean isSepticemia() {
        boolean result = this.claim.isCheckedAndNotNull(Rai300.I2100);
        return result;
    }

    public boolean isDiabetes() {
        boolean result = this.claim.isCheckedAndNotNull(Rai300.I2900) != false && this.claim.hasAssessmentOf(Rai300.N0350A, item -> item.getValueInt() == 7) && this.claim.hasAssessmentOf(Rai300.N0350B, item -> item.getValueInt() >= 2);
        return result;
    }

    public boolean isQuadriplegia() {
        int nursingFunctionScore = this.claim.getFunctionScore();
        boolean result = this.claim.isCheckedAndNotNull(Rai300.I5100) != false && nursingFunctionScore <= 11;
        return result;
    }

    public ClaimInfo getClaim() {
        return this.claim;
    }

    public int getFinalSkinTreatmentsCount() {
        return this.finalSkinTreatmentsCount;
    }

    public boolean isRadiation() {
        return this.radiation;
    }

    public boolean isDialysis() {
        return this.dialysis;
    }
}

