/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.lego.CsvBuilder;
import gov.cms.grouper.snf.lego.Pair;
import gov.cms.grouper.snf.lego.SnfComparator;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.model.CognitiveLevel;
import gov.cms.grouper.snf.model.table.BasicRow;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class CognitiveLevelRow
extends BasicRow {
    public static final BiFunction<CognitiveLevelRow, Pair<Integer, Integer>, Boolean> selector = (row, check) -> SnfComparator.betweenInclusive(row.getLowVersion(), (Comparable)check.getOne(), row.getHighVersion()) && SnfComparator.betweenNullLow(row.getLowScore(), (Comparable)check.getTwo(), row.getHighScore());
    private CognitiveLevel cognitiveLevel;
    private Integer lowScore;
    private Integer highScore;

    private CognitiveLevelRow() {
        this(null, null, null);
    }

    public CognitiveLevelRow(CognitiveLevel cognitiveLevel, Integer lowScore, Integer highScore) {
        this.cognitiveLevel = cognitiveLevel;
        this.lowScore = lowScore;
        this.highScore = highScore;
    }

    public CognitiveLevel getCognitiveLevel() {
        return this.cognitiveLevel;
    }

    public Integer getLowScore() {
        return this.lowScore;
    }

    public Integer getHighScore() {
        return this.highScore;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = super.getHashCode(result, 31);
        result = 31 * result + (this.cognitiveLevel == null ? 0 : this.cognitiveLevel.hashCode());
        result = 31 * result + (this.highScore == null ? 0 : this.highScore.hashCode());
        result = 31 * result + (this.lowScore == null ? 0 : this.lowScore.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CognitiveLevelRow other = (CognitiveLevelRow)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.cognitiveLevel != other.cognitiveLevel) {
            return false;
        }
        if (this.highScore == null ? other.highScore != null : !this.highScore.equals(other.highScore)) {
            return false;
        }
        return !(this.lowScore == null ? other.lowScore != null : !this.lowScore.equals(other.lowScore));
    }

    public static class Builder
    extends CsvBuilder<CognitiveLevelRow> {
        private static final BiConsumer<CognitiveLevelRow, String> level = (val, str) -> CognitiveLevelRow.access$302(val, CognitiveLevel.of(SnfUtils.clean(str)));
        private static final BiConsumer<CognitiveLevelRow, String> low = (val, str) -> CognitiveLevelRow.access$202(val, SnfUtils.parse(str, null));
        private static final BiConsumer<CognitiveLevelRow, String> high = (val, str) -> CognitiveLevelRow.access$102(val, SnfUtils.parse(str, null));
        private static final Builder singleton = new Builder();

        public static Map<Integer, BiConsumer<CognitiveLevelRow, String>> initCsvMapping() {
            HashMap<Integer, BiConsumer<CognitiveLevelRow, String>> result = new HashMap<Integer, BiConsumer<CognitiveLevelRow, String>>();
            result.put(0, level);
            result.put(1, BasicRow.getLowVersionParser());
            result.put(2, BasicRow.getHighVersionParser());
            result.put(3, low);
            result.put(4, high);
            return Collections.unmodifiableMap(result);
        }

        private Builder() {
            super(() -> new CognitiveLevelRow(), Builder.initCsvMapping());
        }

        public static Builder of() {
            return singleton;
        }
    }
}

