/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.lego.CsvBuilder;
import gov.cms.grouper.snf.lego.Pair;
import gov.cms.grouper.snf.lego.SnfComparator;
import gov.cms.grouper.snf.lego.SnfUtils;
import gov.cms.grouper.snf.model.table.BasicRow;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class NtaCmgRow
extends BasicRow {
    public static final BiFunction<NtaCmgRow, Pair<Integer, Integer>, Boolean> verScoreFilter = (row, pair) -> {
        int version = (Integer)pair.getOne();
        int score = (Integer)pair.getTwo();
        boolean correctVer = BasicRow.versionSelector.apply((BasicRow)row, version);
        boolean between = SnfComparator.betweenInclusive(row.getLowScore(), score, row.getHighScore());
        return correctVer && between;
    };
    private String cmg;
    private Integer lowScore;
    private Integer highScore;

    private NtaCmgRow() {
        this(null, null, null);
    }

    public NtaCmgRow(String cmg, Integer lowScore, Integer highScore) {
        this.cmg = cmg;
        this.lowScore = lowScore;
        this.highScore = highScore;
    }

    public String getCmg() {
        return this.cmg;
    }

    public Integer getLowScore() {
        return this.lowScore;
    }

    public Integer getHighScore() {
        return this.highScore;
    }

    public void setCmg(String cmg) {
        this.cmg = cmg;
    }

    public void setLowScore(Integer lowScore) {
        this.lowScore = lowScore;
    }

    public void setHighScore(Integer highScore) {
        this.highScore = highScore;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = super.getHashCode(result, 31);
        result = 31 * result + (this.cmg == null ? 0 : this.cmg.hashCode());
        result = 31 * result + (this.highScore == null ? 0 : this.highScore.hashCode());
        result = 31 * result + (this.lowScore == null ? 0 : this.lowScore.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NtaCmgRow other = (NtaCmgRow)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.cmg == null ? other.cmg != null : !this.cmg.equals(other.cmg)) {
            return false;
        }
        if (this.highScore == null ? other.highScore != null : !this.highScore.equals(other.highScore)) {
            return false;
        }
        return !(this.lowScore == null ? other.lowScore != null : !this.lowScore.equals(other.lowScore));
    }

    public static class Builder
    extends CsvBuilder<NtaCmgRow> {
        private static final BiConsumer<NtaCmgRow, String> cmg = (rowModel, value) -> NtaCmgRow.access$302(rowModel, SnfUtils.clean(value));
        private static final BiConsumer<NtaCmgRow, String> lowScore = (rowModel, value) -> NtaCmgRow.access$202(rowModel, SnfUtils.parse(value, null));
        private static final BiConsumer<NtaCmgRow, String> highScore = (rowModel, value) -> NtaCmgRow.access$102(rowModel, SnfUtils.parse(value, null));
        private static final Builder singleton = new Builder();

        private Builder() {
            super(() -> new NtaCmgRow(), Builder.initCsvMapping());
        }

        private static Map<Integer, BiConsumer<NtaCmgRow, String>> initCsvMapping() {
            HashMap<Integer, BiConsumer<NtaCmgRow, String>> result = new HashMap<Integer, BiConsumer<NtaCmgRow, String>>();
            result.put(0, cmg);
            result.put(1, BasicRow.getLowVersionParser());
            result.put(2, BasicRow.getHighVersionParser());
            result.put(3, lowScore);
            result.put(4, highScore);
            return Collections.unmodifiableMap(result);
        }

        public static Builder of() {
            return singleton;
        }
    }
}

