package gov.cms.grouper.snf.model;

import java.util.HashMap;
import java.util.Map;

/**
 * PDPM Cognitive Levels.
 */
public enum CognitiveLevel {
  COGNITIVELY_INTACT("Cognitively Intact"),
  MILDLY_IMPAIRED("Mildly Impaired"),
  MODERATELY_IMPAIRED("Moderately Impaired"),
  SEVERELY_IMPARED("Severely Impaired");

  private static final Map<String, CognitiveLevel> map = new HashMap<>();
  private final String description;

  CognitiveLevel(String description) {
    this.description = description;
  }

  public String getDescription() {
    return this.description;
  }

  public static CognitiveLevel of(String key) {
    if (CognitiveLevel.map.isEmpty()) {
      for (CognitiveLevel l : CognitiveLevel.values()) {
        CognitiveLevel.map.put(l.getDescription(), l);
      }
    }
    CognitiveLevel level = CognitiveLevel.map.get(key);
    return level;
  }

}
