/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data;
import gov.cms.grouper.snf.model.table.BasicRow;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class NtaComorbidityRow
extends BasicRow {
    private String conditionService;
    private SortedSet<String> mdsItems;
    private Integer point;

    private NtaComorbidityRow() {
    }

    public NtaComorbidityRow(Integer lowVersion, Integer highVersion, String conditionService, SortedSet<String> mdsItems, Integer point) {
        super(lowVersion, highVersion);
        this.conditionService = conditionService;
        this.mdsItems = mdsItems;
        this.point = point;
    }

    public static NtaComorbidityRow build(Data.NtaComorbidityScoreCalc nta) {
        return new NtaComorbidityRow(nta.getLowVersion(), nta.getHighVersion(), nta.getConditionExtensiveService(), Arrays.stream(nta.getMdsItem().split("\\|")).collect(Collectors.toCollection(TreeSet::new)), nta.getPoints());
    }

    public String getConditionService() {
        return this.conditionService;
    }

    public SortedSet<String> getMdsItems() {
        return this.mdsItems;
    }

    public Integer getPoint() {
        return this.point;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = super.getHashCode(result, 31);
        result = 31 * result + (this.conditionService == null ? 0 : this.conditionService.hashCode());
        result = 31 * result + (this.mdsItems == null ? 0 : this.mdsItems.hashCode());
        result = 31 * result + (this.point == null ? 0 : this.point.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NtaComorbidityRow other = (NtaComorbidityRow)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.conditionService == null ? other.conditionService != null : !this.conditionService.equals(other.conditionService)) {
            return false;
        }
        if (this.mdsItems == null ? other.mdsItems != null : !this.mdsItems.equals(other.mdsItems)) {
            return false;
        }
        return !(this.point == null ? other.point != null : !this.point.equals(other.point));
    }

    public String toString() {
        return "NtaComorbidityRow{conditionService='" + this.conditionService + '\'' + ", lowVersion=" + this.getLowVersion() + ", highVersion=" + this.getHighVersion() + ", mdsItems=" + this.mdsItems + ", point=" + this.point + '}';
    }
}

