/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.process;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.cms.grouper.snf.SnfComponentAbstract;
import gov.cms.grouper.snf.SnfComponentVersion;
import gov.cms.grouper.snf.SnfTables;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.SnfProcessError;
import gov.cms.grouper.snf.model.enums.Rai300;
import gov.cms.grouper.snf.model.enums.SnfError;
import gov.cms.grouper.snf.model.table.SnfVersionRow;
import gov.cms.grouper.snf.transfer.SnfClaim;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnfProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SnfProcessor.class);
    private static final int FY2024_VERSION = 220;
    private static final Map<Rai300, Rai300> fy2024Updates = new HashMap<Rai300, Rai300>(){
        {
            this.put(Rai300.D0160, Rai300.D0300);
            this.put(Rai300.K0520A2, Rai300.K0510A1);
            this.put(Rai300.K0520A3, Rai300.K0510A2);
            this.put(Rai300.K0520B2, Rai300.K0510B1);
            this.put(Rai300.K0520B3, Rai300.K0510B2);
            this.put(Rai300.K0520C3, Rai300.K0510C2);
            this.put(Rai300.O0110A1b, Rai300.O0100A2);
            this.put(Rai300.O0110B1b, Rai300.O0100B2);
            this.put(Rai300.O0110C1b, Rai300.O0100C2);
            this.put(Rai300.O0110D1b, Rai300.O0100D2);
            this.put(Rai300.O0110E1b, Rai300.O0100E2);
            this.put(Rai300.O0110F1b, Rai300.O0100F2);
            this.put(Rai300.O0110H1b, Rai300.O0100H2);
            this.put(Rai300.O0110I1b, Rai300.O0100I2);
            this.put(Rai300.O0110J1b, Rai300.O0100J2);
            this.put(Rai300.O0110M1b, Rai300.O0100M2);
        }
    };

    protected SnfProcessor() {
    }

    protected static Integer getDataVersion(LocalDate date) {
        Integer version = null;
        for (Map.Entry<Integer, SnfVersionRow> row : SnfTables.versions.entrySet()) {
            if (!row.getValue().isDate(date)) continue;
            version = row.getKey();
            break;
        }
        return version;
    }

    protected SnfClaim process(SnfClaim claim, Consumer<SnfClaim> finalProcessing) throws FoundationException, IOException {
        int correctDataVersion = SnfProcessor.getDataVersion(claim.getAssessmentReferenceDate());
        SnfComponentVersion releaseVersion = SnfComponentVersion.of(correctDataVersion);
        claim.setVersion(correctDataVersion);
        claim.setRecalculated_z0100b(SnfTables.getRecalculatedZ0100B());
        this.retiredItemSetUpdate(correctDataVersion, claim);
        if (releaseVersion == null) {
            claim.addErrors(SnfError.INVALID_ASSESSMENT_REFERENCE_DATE.getReason(new String[0]));
        } else {
            try (SnfComponentAbstract snfComponent = releaseVersion.getCreateComponent().apply(correctDataVersion);){
                snfComponent.process(claim);
            }
            catch (SnfProcessError se) {
                LOG.debug(se.getMessage());
                throw se;
            }
            catch (Throwable th) {
                LOG.debug(th.getMessage());
                claim.addErrors(SnfError.PROCESS_ERROR.getReason(th.getMessage()));
                throw th;
            }
        }
        if (finalProcessing != null) {
            finalProcessing.accept(claim);
        }
        return claim;
    }

    protected void retiredItemSetUpdate(int dataVersion, SnfClaim snfClaim) {
        Map<String, Assessment> assessmentMap = snfClaim.getAssessmentMap();
        if (dataVersion >= 220) {
            for (Map.Entry<Rai300, Rai300> update : fy2024Updates.entrySet()) {
                Rai300 newItem = update.getKey();
                Rai300 oldItem = update.getValue();
                if (!assessmentMap.containsKey(newItem.getXmlTag())) continue;
                Assessment hybridAssessment = new Assessment(oldItem.name(), oldItem.getXmlTag(), assessmentMap.get(newItem.getXmlTag()));
                assessmentMap.put(oldItem.getXmlTag(), hybridAssessment);
            }
        }
    }
}

