/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.r2;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.cms.grouper.snf.SnfComponentAbstract;
import gov.cms.grouper.snf.SnfComponentVersion;
import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.SnfRuntimeOption;
import gov.cms.grouper.snf.SnfTables;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import gov.cms.grouper.snf.model.SnfProcessError;
import gov.cms.grouper.snf.model.enums.AssessmentIndicator;
import gov.cms.grouper.snf.model.enums.ClinicalCategory;
import gov.cms.grouper.snf.model.enums.CognitiveLevel;
import gov.cms.grouper.snf.model.enums.NursingCmg;
import gov.cms.grouper.snf.model.enums.Rai300;
import gov.cms.grouper.snf.model.enums.SnfError;
import gov.cms.grouper.snf.model.table.BasicRow;
import gov.cms.grouper.snf.model.table.ClinicalCategoryMasterRow;
import gov.cms.grouper.snf.model.table.NtaComorbidityMasterRow;
import gov.cms.grouper.snf.model.table.SlpComorbidityMasterRow;
import gov.cms.grouper.snf.r2.logic.CognitiveLevelLogic;
import gov.cms.grouper.snf.r2.logic.NtaLogic;
import gov.cms.grouper.snf.r2.logic.NursingLogic;
import gov.cms.grouper.snf.r2.logic.SpeechLogic;
import gov.cms.grouper.snf.r2.logic.TherapyLogic;
import gov.cms.grouper.snf.r2.logic.nursing.BscpLogic;
import gov.cms.grouper.snf.r2.logic.nursing.ReducedPhysicalFunctionLogic;
import gov.cms.grouper.snf.r2.logic.nursing.SpecialCare;
import gov.cms.grouper.snf.transfer.ISnfClaim;
import gov.cms.grouper.snf.util.ClaimInfo;
import gov.cms.grouper.snf.util.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnfComponent
extends SnfComponentAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(SnfComponent.class);

    public SnfComponent() {
        this(100);
    }

    public SnfComponent(int dataVersion) {
        super(dataVersion);
        if (this.getClass().equals(SnfComponent.class) && (SnfComponentVersion.r2.getFrom() > dataVersion || dataVersion > SnfComponentVersion.r2.getTo())) {
            throw new RuntimeException("Version miss match");
        }
    }

    protected static String getHIPPSCode(String therapyCmg, String speechCmg, NursingCmg nursingCmg, String ntaCmg, Integer assessmentIndicator) {
        return String.join((CharSequence)"", therapyCmg.substring(1), speechCmg.substring(1), nursingCmg.getHipps(), ntaCmg.substring(1), Objects.toString(assessmentIndicator, ""));
    }

    public static List<SnfDiagnosisCode> populate(int version, Iterable<SnfDiagnosisCode> dxCodes) {
        ArrayList<SnfDiagnosisCode> result = new ArrayList<SnfDiagnosisCode>();
        for (SnfDiagnosisCode code : dxCodes) {
            try {
                String slpCategory;
                String trimmedCode = code.getValue().replaceAll("[.^]", "").trim();
                ClinicalCategoryMasterRow clinicalCategoryMasterRow = SnfTables.get(SnfTables.clinicalCategoryMasterTable, trimmedCode, BasicRow::isVersion, version);
                SlpComorbidityMasterRow slpComorbidityMasterRow = SnfTables.get(SnfTables.slpComorbidityMasterTable, trimmedCode, BasicRow::isVersion, version);
                Set<NtaComorbidityMasterRow> ntaComorbidityMasterRows = SnfTables.getAll(SnfTables.ntaComorbidityMasterTable, trimmedCode, BasicRow::isVersion, version);
                String clinicalCategory = clinicalCategoryMasterRow == null ? null : clinicalCategoryMasterRow.getClinicalCategory();
                String string = slpCategory = slpComorbidityMasterRow == null ? null : slpComorbidityMasterRow.getSlpCategory();
                if (ntaComorbidityMasterRows == null) {
                    result.add(new SnfDiagnosisCode(trimmedCode, clinicalCategory, slpCategory, null));
                    continue;
                }
                ntaComorbidityMasterRows.forEach(ntaComorbidityMasterRow -> result.add(new SnfDiagnosisCode(trimmedCode, clinicalCategory, slpCategory, ntaComorbidityMasterRow.getNtaCategory())));
            }
            catch (NullPointerException ex) {
                LOG.warn("Invalid ICD 10 code: {}", (Object)code.getValue());
            }
        }
        return result;
    }

    @Override
    public Boolean hasIPA(Integer aiCode, Integer obra) {
        Boolean hasIpa = null;
        if (aiCode != null) {
            if (aiCode.intValue() == AssessmentIndicator.FIVE_DAY.getValue()) {
                hasIpa = false;
            } else if (aiCode.intValue() == AssessmentIndicator.INTERIM_PAYMENT_ASSESSMENT.getValue()) {
                hasIpa = true;
            }
        }
        return hasIpa;
    }

    private static void addInvalidControlElementsError(ISnfClaim claim) {
        if (claim.getOriginalRecord() == null) {
            claim.addErrors(SnfError.INVALID_A0310A_OR_A0310B.getReason(claim.getAiCode().toString(), claim.getObra().toString()));
        } else {
            int begin = Rai300.A0310A.getIndex() - 1;
            int end = begin + Rai300.A0310A.getLength();
            String obraValue = claim.getOriginalRecord().substring(begin, end);
            begin = Rai300.A0310B.getIndex() - 1;
            end = begin + Rai300.A0310B.getLength();
            String ppsValue = claim.getOriginalRecord().substring(begin, end);
            claim.addErrors(SnfError.INVALID_A0310A_OR_A0310B.getReason(obraValue, ppsValue));
        }
    }

    @Override
    public void reconfigure(SnfRuntimeOption option) throws FoundationException {
    }

    @Override
    public void exec(ISnfClaim claim) {
        SnfContext.trace(claim);
        Integer assessmentIndicator = claim.getAssessmentIndicator();
        Boolean hasIPA = this.hasIPA(assessmentIndicator, claim.getObra());
        if (hasIPA == null) {
            SnfComponent.addInvalidControlElementsError(claim);
        }
        if (claim.hasError()) {
            throw new SnfProcessError();
        }
        ClaimInfo asstInfo = ClaimInfo.of(this.getDataVersion(), (boolean)hasIPA, claim.getAssessmentMap());
        try {
            String trimmedPdx = claim.getPrimaryDiagnosis().getValue().replaceAll("[.^]", "").trim();
            ClinicalCategoryMasterRow clinicalCategoryMasterRow = SnfTables.get(SnfTables.clinicalCategoryMasterTable, trimmedPdx, BasicRow::isVersion, this.getDataVersion());
            SlpComorbidityMasterRow slpComorbidityMasterRow = SnfTables.get(SnfTables.slpComorbidityMasterTable, trimmedPdx, BasicRow::isVersion, this.getDataVersion());
            NtaComorbidityMasterRow ntaComorbidityMasterRow = SnfTables.get(SnfTables.ntaComorbidityMasterTable, trimmedPdx, BasicRow::isVersion, this.getDataVersion());
            String clinicalCategory = clinicalCategoryMasterRow == null ? null : clinicalCategoryMasterRow.getClinicalCategory();
            String slpCategory = slpComorbidityMasterRow == null ? null : slpComorbidityMasterRow.getSlpCategory();
            String ntaCategory = ntaComorbidityMasterRow == null ? null : ntaComorbidityMasterRow.getNtaCategory();
            SnfDiagnosisCode pdx = new SnfDiagnosisCode(trimmedPdx, clinicalCategory, slpCategory, ntaCategory);
            claim.setPrimaryDiagnosis(pdx);
        }
        catch (NullPointerException ex) {
            LOG.warn("Invalid Pdx code: {}", (Object)claim.getPrimaryDiagnosis().getValue());
        }
        if (claim.getPrimaryDiagnosis().getClinicalCategory() == null || claim.getPrimaryDiagnosis().getClinicalCategory().equals(ClinicalCategory.RETURN_TO_PROVIDER.getDescription()) && assessmentIndicator != null) {
            claim.setHippsCode("");
            return;
        }
        List<SnfDiagnosisCode> secondaryDiagnoses = SnfComponent.populate(this.getDataVersion(), claim.getSecondaryDiagnoses());
        ClinicalCategory pdxClinicalCategory = TherapyLogic.getPdxClinicalCategory(this.getDataVersion(), asstInfo, claim.getPrimaryDiagnosis().getValue());
        if (!claim.hasError()) {
            String therapyLogicCmg = new TherapyLogic(this.getDataVersion(), asstInfo, pdxClinicalCategory).exec();
            CognitiveLevel cognitiveLevel = new CognitiveLevelLogic(asstInfo).exec();
            String speechLogicCmg = new SpeechLogic(this.getDataVersion(), asstInfo, secondaryDiagnoses, cognitiveLevel, pdxClinicalCategory).exec();
            Reference<ReducedPhysicalFunctionLogic> physicRef = new Reference<ReducedPhysicalFunctionLogic>();
            SpecialCare specialCare = new SpecialCare(asstInfo);
            BscpLogic bscp = new BscpLogic(asstInfo, physicRef);
            ReducedPhysicalFunctionLogic physical = new ReducedPhysicalFunctionLogic(asstInfo, bscp);
            physicRef.set(physical);
            NursingCmg nursingLogicCmg = new NursingLogic(asstInfo, specialCare, physical, bscp).exec();
            String ntaPaymentCompLogicCmg = new NtaLogic(asstInfo, secondaryDiagnoses).exec();
            String hippsCode = SnfComponent.getHIPPSCode(therapyLogicCmg, speechLogicCmg, nursingLogicCmg, ntaPaymentCompLogicCmg, assessmentIndicator);
            claim.setHippsCode(hippsCode);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    @Override
    public SnfError validates(ISnfClaim claim) {
        return null;
    }
}

