/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.r2.logic;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.SnfTables;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import gov.cms.grouper.snf.model.enums.Rai300;
import gov.cms.grouper.snf.model.table.NtaCmgRow;
import gov.cms.grouper.snf.model.table.NtaComorbidityRow;
import gov.cms.grouper.snf.r2.logic.SnfDataVersionImpl;
import gov.cms.grouper.snf.util.ClaimInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class NtaLogic
extends SnfDataVersionImpl<String> {
    public static final Function<String, Predicate<NtaComorbidityRow>> FeedingFilter = condition -> dataRow -> condition.equalsIgnoreCase(dataRow.getConditionService());
    public static final String ICD10_CODE_HIV = "B20";
    private final Set<String> secondaryDxNtaCategories;
    private final Set<String> assessmentNames;
    private final Supplier<Boolean> hasK0510A2;
    private final Supplier<Integer> k0710A2Value;
    private final Supplier<Integer> k0710B2Value;
    private final Predicate<NtaComorbidityRow> parenteralIvFeeding;
    private final Predicate<NtaComorbidityRow> step1$3AdditionalComorbidities;
    private final ClaimInfo claim;

    public NtaLogic(ClaimInfo claim, List<SnfDiagnosisCode> secondaryDiagnosis) {
        super(claim.getDataVersion());
        this.claim = claim;
        this.assessmentNames = claim.getAssessmentNames(item -> item.isCheck() && !item.getItem().equals("M0300D1"));
        this.assessmentNames.addAll(claim.getAssessmentNames(item -> item.getValueInt() > 0 && item.getItem().equals("M0300D1")));
        this.secondaryDxNtaCategories = ClaimInfo.getNtaCategories(secondaryDiagnosis.stream().filter(snfDiagnosisCode -> !snfDiagnosisCode.getValue().equals(ICD10_CODE_HIV)).collect(Collectors.toList()));
        this.hasK0510A2 = () -> claim.isCheckedAndNotNull(Rai300.K0510A2);
        this.k0710A2Value = () -> claim.getAssessmentValue(Rai300.K0710A2);
        this.k0710B2Value = () -> claim.getAssessmentValue(Rai300.K0710B2);
        this.parenteralIvFeeding = this.step1$2ParenteralIvFeedingCondition(this.hasK0510A2, this.k0710A2Value, this.k0710B2Value);
        this.step1$3AdditionalComorbidities = row -> this.step1$3AdditionalComorbidities((Iterable<String>)this.assessmentNames, (NtaComorbidityRow)row);
    }

    public Predicate<NtaComorbidityRow> step1$2ParenteralIvFeedingCondition(Supplier<Boolean> hasK0510A2, Supplier<Integer> k0710A2Value, Supplier<Integer> k0710B2Value) {
        ParenteralIvFeeding feeding = null;
        if (hasK0510A2.get().booleanValue()) {
            int k0710A2 = k0710A2Value.get();
            if (k0710A2 == 3) {
                feeding = ParenteralIvFeeding.HighIntensity;
            } else if (k0710A2 == 2 && k0710B2Value.get() == 2) {
                feeding = ParenteralIvFeeding.LowIntensity;
            }
        }
        Predicate<NtaComorbidityRow> result = row -> Boolean.FALSE;
        if (feeding != null) {
            result = FeedingFilter.apply(feeding.getConditionService());
        }
        return SnfContext.trace(feeding, result);
    }

    public boolean step1$3AdditionalComorbidities(Iterable<String> assessmentNames, NtaComorbidityRow row) {
        boolean result = false;
        for (String name : assessmentNames) {
            if (!row.getMdsItems().contains(name) || row.getConditionService().equalsIgnoreCase("Parenteral IV Feeding: Level High") || row.getConditionService().equalsIgnoreCase("Parenteral IV Feeding: Level Low")) continue;
            result = true;
            SnfContext.trace(name);
            break;
        }
        return result;
    }

    public int step2NtaScore(Collection<String> secondaryDxNtaCategories, Predicate<NtaComorbidityRow> step1$3AdditionalComorbidities, Predicate<NtaComorbidityRow> parenteralIvFeedingFilter) {
        Predicate<NtaComorbidityRow> conditionService = row -> secondaryDxNtaCategories.contains(row.getConditionService());
        Predicate<NtaComorbidityRow> conditions = conditionService.or(parenteralIvFeedingFilter).or(step1$3AdditionalComorbidities);
        conditions = conditions.and(row -> row.isVersion(super.getDataVersion()));
        List<Integer> scores = SnfTables.selectAll(SnfTables.ntaComorbidityTableByConditionOfService, conditions, row -> {
            SnfContext.trace(row.toString());
            return row.getPoint();
        });
        Integer sum = scores.stream().reduce(0, Integer::sum);
        return SnfContext.trace(sum);
    }

    public String step3NtaCaseMixGroup(int ntaScore) {
        NtaCmgRow row = SnfTables.ntaCmgTable.values().stream().flatMap(Collection::stream).filter(item -> item.isVersion(this.getDataVersion()) && item.isScore(ntaScore)).findFirst().orElse(null);
        String cmg = row.getCmg();
        return SnfContext.trace(cmg);
    }

    @Override
    public String exec() {
        int ntaScore = this.step2NtaScore(this.secondaryDxNtaCategories, this.step1$3AdditionalComorbidities, this.parenteralIvFeeding);
        String result = this.step3NtaCaseMixGroup(ntaScore);
        return SnfContext.trace(result);
    }

    public ClaimInfo getClaim() {
        return this.claim;
    }

    public static enum ParenteralIvFeeding {
        HighIntensity(Arrays.asList(Rai300.K0510A2.name(), Rai300.K0710A2.name()), "Parenteral IV Feeding: Level High"),
        HighIntensity_V220(Arrays.asList(Rai300.K0520A3.name(), Rai300.K0710A2.name()), "Parenteral IV Feeding: Level High"),
        LowIntensity(Arrays.asList(Rai300.K0510A2.name(), Rai300.K0710A2.name(), Rai300.K0710B2.name()), "Parenteral IV Feeding: Level Low"),
        LowIntensity_V220(Arrays.asList(Rai300.K0520A3.name(), Rai300.K0710A2.name(), Rai300.K0710B2.name()), "Parenteral IV Feeding: Level Low");

        private final SortedSet<String> items;
        private final String conditionService;

        private ParenteralIvFeeding(List<String> items, String conditionService) {
            this.items = Collections.unmodifiableSortedSet(new TreeSet<String>(items));
            this.conditionService = conditionService;
        }

        public SortedSet<String> getItems() {
            return this.items;
        }

        public String getConditionService() {
            return this.conditionService;
        }
    }
}

