package gov.cms.grouper.snf.model;

// MUST REMAIN PUBLIC
// TODO: Needs documentation

/**
 * Quality measures of the patients: Hearing, speech, vision, cognitive patterns, functional
 * abilities and goals, bladder and bowel...
 */
public class Assessment {

  public static final int NULL_VALUE = Integer.MIN_VALUE;
  public static final int CHECKED = 1;

  private final String name;
  private final String item; // xml tag
  private final Integer value;
  private final boolean isBlank;
  private final boolean isAssessed;

  /**
   * Constructs with a name, xml tag and value.
   *
   * @param name  non-null String.
   * @param item  non-null XML name, can be the same as name.
   * @param value non-null integer value.
   */
  public Assessment(String name, String item, Integer value) {
    this.name = name;
    this.item = item;
    this.value = value;
    isBlank = false;
    isAssessed = true;
  }

  /**
   * Constructs with a name, xml tag and value.
   *
   * @param name  non-null String.
   * @param item  non-null XML name, can be the same as name.
   * @param value non-null integer value, blank, ^ or -
   */
  public Assessment(String name, String item, String value) {
    int tempVal;
    this.name = name;
    this.item = item;
    try {
      tempVal = Integer.parseInt(value.trim());
    } catch (NumberFormatException e) {
      tempVal = NULL_VALUE;
    }
    this.value = tempVal;
    isBlank = (value.isEmpty() || value.contains("^"));
    isAssessed = !value.contains("-");
  }

  /**
   * Constructs with a name, xml tag, and assessment to clone value, isBlank, and isAssessed from
   * @param name  non-null String.
   * @param item  non-null XML name, can be the same as name.
   * @param assessment non-null Assessment to pull value, isBlank, and isAssessed from.
   */
  public Assessment(String name, String item, Assessment assessment) {
    this.name = name;
    this.item = item;
    value = assessment.value;
    isBlank = assessment.isBlank;
    isAssessed = assessment.isAssessed;
  }

  public String getName() {
    return name;
  }

  public String getItem() {
    return item;
  }

  public int getValueInt() {
    return value == null ? Assessment.NULL_VALUE : value;
  }

  public Integer getValue() {
    return value;
  }

  public boolean isBlank() {
    return isBlank;
  }

  public boolean isAssessed() {
    return isAssessed;
  }

  public boolean isCheck() {
    return getValueInt() == Assessment.CHECKED;
  }

  @Override
  public String toString() {
    return "Assessment{" + "name='" + name + '\'' + ", item='" + item + '\'' + ", value="
        + value + '}';
  }
}
