package gov.cms.grouper.snf.model.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * PDPM Cognitive Levels.
 */
public enum CognitiveLevel {
  COGNITIVELY_INTACT("Cognitively Intact"),
  MILDLY_IMPAIRED("Mildly Impaired"),
  MODERATELY_IMPAIRED("Moderately Impaired"),
  SEVERELY_IMPAIRED("Severely Impaired");

  private static final Map<String, CognitiveLevel> CACHE = new HashMap<>();
  private final String description;

  CognitiveLevel(String description) {
    this.description = description;
  }

  public static CognitiveLevel of(String key) {
    if (CognitiveLevel.CACHE.isEmpty()) {
      for (CognitiveLevel level : CognitiveLevel.values()) {
        CognitiveLevel.CACHE.put(level.getDescription(), level);
      }
    }
    return CognitiveLevel.CACHE.get(key);
  }

  public String getDescription() {
    return description;
  }

}
