package gov.cms.grouper.snf.model.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum PpsAssessment {
    FIVE_DAY (1, "5-day scheduled assessment"),
    IPA (8, "Interim Payment Assessment"),
    NONE (99, "None of the above");

    private Integer value;
    private String description;

    private static final Map<Integer, PpsAssessment> valueMap = new HashMap<>();
    static {
        for (PpsAssessment ppsAssessment : values()) {
            valueMap.put(ppsAssessment.value, ppsAssessment);
        }
    }

    PpsAssessment(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    public static Optional<PpsAssessment> of(Integer value) {
        return Optional.ofNullable(valueMap.get(value));
    }

    public Integer getValue() {
        return value;
    }

    public String getDescription() {
        return description;
    }
}
