package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data.NtaComorbidityScoreCalc;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class NtaComorbidityRow extends BasicRow {

  private String conditionService;
  private SortedSet<String> mdsItems;
  private Integer point;

  private NtaComorbidityRow() {}

  public NtaComorbidityRow(Integer lowVersion, Integer highVersion, String conditionService, SortedSet<String> mdsItems, Integer point) {
    super(lowVersion, highVersion);
    this.conditionService = conditionService;
    this.mdsItems = mdsItems;
    this.point = point;
  }

  public static NtaComorbidityRow build(NtaComorbidityScoreCalc nta) {
    return new NtaComorbidityRow(nta.getLowVersion(), nta.getHighVersion(),
        nta.getConditionExtensiveService(),
        Arrays.stream(nta.getMdsItem().split("\\|")).collect(Collectors.toCollection(TreeSet::new)),
        nta.getPoints());
  }

  public String getConditionService() {
    return conditionService;
  }

  public SortedSet<String> getMdsItems() {
    return mdsItems;
  }

  public Integer getPoint() {
    return point;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result =
        prime * result + ((conditionService == null) ? 0 : conditionService.hashCode());
    result = prime * result + ((mdsItems == null) ? 0 : mdsItems.hashCode());
    result = prime * result + ((point == null) ? 0 : point.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    NtaComorbidityRow other = (NtaComorbidityRow) obj;
    if (super.equals(other) == false) {
      return false;
    }

    if (conditionService == null) {
      if (other.conditionService != null) {
        return false;
      }
    } else if (!conditionService.equals(other.conditionService)) {
      return false;
    }
    if (mdsItems == null) {
      if (other.mdsItems != null) {
        return false;
      }
    } else if (!mdsItems.equals(other.mdsItems)) {
      return false;
    }
    if (point == null) {
      if (other.point != null) {
        return false;
      }
    } else if (!point.equals(other.point)) {
      return false;
    }
    return true;
  }

  @Override
  public String toString() {
    return "NtaComorbidityRow{" +
            "conditionService='" + conditionService + '\'' +
            ", lowVersion=" + getLowVersion() +
            ", highVersion=" + getHighVersion() +
            ", mdsItems=" + mdsItems +
            ", point=" + point +
            '}';
  }
}
