package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data.SlpComorbidities;

public class SlpComorbiditiesRow extends BasicRow {

  public static final String I8000 = "I8000";

  private String mdsItem;
  private String category;

  private SlpComorbiditiesRow() {}

  public SlpComorbiditiesRow(Integer lowVersion, Integer highVersion, String mdsItem, String category) {
    super(lowVersion, highVersion);
    this.mdsItem = mdsItem;
    this.category = category;
  }

  public static SlpComorbiditiesRow build(SlpComorbidities como) {
    return new SlpComorbiditiesRow(como.getLowVersion(), como.getHighVersion(), como.getMdsItem(),
        como.getCategory());
  }

  public String getMdsItem() {
    return mdsItem;
  }

  public String getCategory() {
    return category;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result = prime * result + ((category == null) ? 0 : category.hashCode());
    result = prime * result + ((mdsItem == null) ? 0 : mdsItem.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    SlpComorbiditiesRow other = (SlpComorbiditiesRow) obj;
    if (super.equals(other) == false) {
      return false;
    }

    if (category == null) {
      if (other.category != null) {
        return false;
      }
    } else if (!category.equals(other.category)) {
      return false;
    }
    if (mdsItem == null) {
      if (other.mdsItem != null) {
        return false;
      }
    } else if (!mdsItem.equals(other.mdsItem)) {
      return false;
    }
    return true;
  }

}
