package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.Data.Version;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class SnfVersionRow {

  public boolean isDate(LocalDate check) {
    boolean passesLow = from == null || from.equals(check) || from.isBefore(check);
    boolean passesHigh = to == null || to.equals(check) || to.isAfter(check);
    return passesLow && passesHigh;
  }

  private Integer internalVersion;
  private LocalDate from;
  private LocalDate to;
  private String version;

  private SnfVersionRow() {}

  public SnfVersionRow(Integer internalVersion, LocalDate from, LocalDate to, String version) {
    this.internalVersion = internalVersion;
    this.from = from;
    this.to = to;
    this.version = version;
  }

  public Integer getInternalVersion() { return internalVersion; }

  public LocalDate getFrom() {
    return from;
  }

  public LocalDate getTo() {
    return to;
  }

  public String getVersion() {
    return version;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((from == null) ? 0 : from.hashCode());
    result = prime * result + ((to == null) ? 0 : to.hashCode());
    result =
        prime * result + ((internalVersion == null) ? 0 : internalVersion.hashCode());
    result = prime * result + ((version == null) ? 0 : version.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    SnfVersionRow other = (SnfVersionRow) obj;
    if (from == null) {
      if (other.from != null) {
        return false;
      }
    } else if (!from.equals(other.from)) {
      return false;
    }
    if (to == null) {
      if (other.to != null) {
        return false;
      }
    } else if (!to.equals(other.to)) {
      return false;
    }
    if (internalVersion == null) {
      if (other.internalVersion != null) {
        return false;
      }
    } else if (!internalVersion.equals(other.internalVersion)) {
      return false;
    }
    if (version == null) {
      if (other.version != null) {
        return false;
      }
    } else if (!version.equals(other.version)) {
      return false;
    }
    return true;
  }

  public static SnfVersionRow build(Version version) {
    return new SnfVersionRow(Integer.parseInt(version.getInternalVersion()),
        LocalDate.parse(version.getStartDate(), DateTimeFormatter.BASIC_ISO_DATE),
        LocalDate.parse(version.getEndDate(), DateTimeFormatter.BASIC_ISO_DATE),
        version.getVersion());
  }

}
