package gov.cms.grouper.snf.r3;


import gov.cms.grouper.snf.SnfComponentVersion;

public class SnfComponent extends gov.cms.grouper.snf.r2.SnfComponent {

  private static final int OBRA_STARTVERSION = 105;

  public SnfComponent() {
    this(OBRA_STARTVERSION);
  }


  public SnfComponent(int dataVersion) {
    super(dataVersion);
    if (!(SnfComponentVersion.r3.getFrom() <= dataVersion
            && dataVersion <= SnfComponentVersion.r3.getTo())) {
      throw new RuntimeException("Version mismatch");
    }
  }


  @Override
  public Boolean hasIPA(Integer aiCode, Integer obra) {
    Boolean hasIpa;

    // OBRA assessment do not have Interim Payment Assessments (IPA)
    if (obra != null && obra != 99 && aiCode == null) {
      hasIpa = false;
    } else {
      hasIpa = super.hasIPA(aiCode, obra);
    }

    return hasIpa;

  }


}
