/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf;

import com.mmm.his.cer.foundation.Processable;
import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.cms.grouper.snf.SnfOption;
import gov.cms.grouper.snf.SnfRuntimeOption;
import gov.cms.grouper.snf.model.enums.ObraAssessment;
import gov.cms.grouper.snf.model.enums.PpsAssessment;
import gov.cms.grouper.snf.model.enums.SnfError;
import gov.cms.grouper.snf.transfer.ISnfClaim;
import java.io.IOException;

public abstract class SnfComponentAbstract
implements Processable<ISnfClaim, SnfOption, SnfRuntimeOption> {
    private final int dataVersion;

    protected SnfComponentAbstract(int dataVersion) {
        this.dataVersion = dataVersion;
    }

    public void process(ISnfClaim claim) throws FoundationException {
        SnfError validationError = this.validates(claim);
        if (validationError == null) {
            this.exec(claim);
        } else {
            claim.addErrors(validationError.getReason(new String[0]));
        }
    }

    public abstract Boolean isInterimPayment(PpsAssessment var1, ObraAssessment var2);

    public abstract void exec(ISnfClaim var1);

    public abstract SnfError validates(ISnfClaim var1);

    public void close() throws IOException {
    }

    public void reconfigure(SnfRuntimeOption option) throws FoundationException {
    }

    public int getDataVersion() {
        return this.dataVersion;
    }
}

