/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.r2.logic.nursing;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.enums.NursingCmg;
import gov.cms.grouper.snf.model.enums.Rai300;
import gov.cms.grouper.snf.r2.logic.SnfDataVersionImpl;
import gov.cms.grouper.snf.r2.logic.nursing.RaiSets;
import gov.cms.grouper.snf.r2.logic.nursing.ReducedPhysicalFunctionLogic;
import gov.cms.grouper.snf.util.ClaimInfo;
import gov.cms.grouper.snf.util.Lazy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public class BscpLogic
extends SnfDataVersionImpl<NursingCmg> {
    public static final int FUNCTION_SCORE_LIMIT = 11;
    public static final int NURSING_COUNT_NUM_DAYS_IN_LAST_7_DAYS = 6;
    private final ClaimInfo claim;
    private final Supplier<ReducedPhysicalFunctionLogic> physicalSupplier;
    private final Integer c0500;
    private final Integer c0100;
    private final Boolean isBehavioralSymptomsPresent;
    private final Supplier<NursingCmg> physicalCmg;

    public BscpLogic(ClaimInfo claim, Supplier<ReducedPhysicalFunctionLogic> physicalSupplier) {
        super(claim.getDataVersion());
        this.claim = claim;
        this.physicalSupplier = physicalSupplier;
        this.c0500 = claim.getAssessmentValue(Rai300.C0500);
        this.c0100 = claim.getAssessmentValue(Rai300.C0100);
        this.isBehavioralSymptomsPresent = this.getBehavioralSymptomsPresent();
        this.physicalCmg = new Lazy<NursingCmg>(() -> ((ReducedPhysicalFunctionLogic)physicalSupplier.get()).exec());
    }

    public List<Assessment> getBehavioralSymptomsAssessmentList(ClaimInfo claim) {
        ArrayList<Assessment> result = new ArrayList<Assessment>();
        for (Rai300 rai : RaiSets.BEHAVIORAL_SYMPTOMS.getSet()) {
            Assessment ast = claim.getAssessment(rai);
            if (ast == null) continue;
            result.add(ast);
        }
        return Collections.unmodifiableList(result);
    }

    public boolean isClassifiedBehavioralSymptomsCognitivePerformance() {
        Lazy<Boolean> comatoseSupplier = new Lazy<Boolean>(() -> this.claim.isComaAndNoActivities());
        boolean result = ClaimInfo.isClassifiedBehavioralSymptomsCognitivePerformance(() -> this.claim.getAssessmentValue(Rai300.B0700), () -> this.claim.getAssessmentValue(Rai300.C0700), () -> this.claim.getAssessmentValue(Rai300.C1000), comatoseSupplier);
        return result;
    }

    public Boolean getBehavioralSymptomsPresent() {
        boolean e0100AChecked = this.claim.isCheckedAndNotNull(Rai300.E0100A);
        boolean e0100BChecked = this.claim.isCheckedAndNotNull(Rai300.E0100B);
        List<Assessment> behavioralSymptomsAssessmentList = this.getBehavioralSymptomsAssessmentList(this.claim);
        boolean hasSymptoms = this.hasSymptoms(behavioralSymptomsAssessmentList);
        return this.isBehavioralSymptomsPresent(e0100AChecked, e0100BChecked, hasSymptoms);
    }

    public boolean isBehavioralSymptomsPresent(boolean e0100AChecked, boolean e0100BChecked, boolean hasSymptoms) {
        return hasSymptoms || e0100BChecked || e0100AChecked;
    }

    public boolean hasSymptoms(List<Assessment> behavioralSymptomsAssessmentList) {
        Assessment ast;
        boolean hasSymptoms = false;
        Iterator<Assessment> iterator = behavioralSymptomsAssessmentList.iterator();
        while (iterator.hasNext() && !(hasSymptoms = (ast = iterator.next()).getValueInt() >= 2)) {
        }
        return hasSymptoms;
    }

    protected NursingCmg step4(boolean isBehavioralSymptomsPresent) {
        NursingCmg result = isBehavioralSymptomsPresent ? this.step6() : this.physicalSupplier.get().exec();
        return SnfContext.trace(result);
    }

    public int step5() {
        int restorativeNursingCount = 0;
        int h0200C = this.claim.getAssessmentValue(Rai300.H0200C);
        int h0500 = this.claim.getAssessmentValue(Rai300.H0500);
        int o0500A = this.claim.getAssessmentValue(Rai300.O0500A);
        int o0500B = this.claim.getAssessmentValue(Rai300.O0500B);
        int o0500D = this.claim.getAssessmentValue(Rai300.O0500D);
        int o0500F = this.claim.getAssessmentValue(Rai300.O0500F);
        if (h0200C == 1 || h0500 == 1) {
            ++restorativeNursingCount;
        }
        if (o0500A >= 6 || o0500B >= 6) {
            ++restorativeNursingCount;
        }
        if (o0500D >= 6 || o0500F >= 6) {
            ++restorativeNursingCount;
        }
        for (Rai300 service : RaiSets.BSCP_SERVICES.getSet()) {
            if (this.claim.getAssessmentValue(service) < 6) continue;
            ++restorativeNursingCount;
        }
        return SnfContext.trace(restorativeNursingCount);
    }

    protected NursingCmg step6() {
        int nursingFunctionScore = this.claim.getFunctionScore();
        NursingCmg result = null;
        if (11 <= nursingFunctionScore && nursingFunctionScore <= 16) {
            int step5RestorativeNursingCount = this.step5();
            result = step5RestorativeNursingCount >= 2 ? NursingCmg.BAB2 : NursingCmg.BAB1;
        }
        return SnfContext.trace(result);
    }

    public NursingCmg eval(boolean isClassifiedBehavioralSymptomsCognitivePerformance, Integer c0500, Integer c0100, Supplier<NursingCmg> physicalSupplier) {
        NursingCmg result = null;
        int nursingFunctionScore = this.claim.getFunctionScore();
        result = nursingFunctionScore < 11 ? physicalSupplier.get() : (c0100 != 0 && c0500 <= 9 && c0100 != Integer.MIN_VALUE && c0500 != Integer.MIN_VALUE ? this.step6() : (c0100 != 0 && c0500 > 9 && c0500 != 99 ? this.step4(this.isBehavioralSymptomsPresent) : (isClassifiedBehavioralSymptomsCognitivePerformance ? this.step6() : this.step4(this.isBehavioralSymptomsPresent))));
        return SnfContext.trace(result);
    }

    @Override
    public NursingCmg exec() {
        boolean isClassifiedBehavioralSymptomsCognitivePerformance = this.isClassifiedBehavioralSymptomsCognitivePerformance();
        NursingCmg result = this.eval(isClassifiedBehavioralSymptomsCognitivePerformance, this.c0500, this.c0100, this.physicalCmg);
        return SnfContext.trace(result);
    }
}

