package gov.cms.grouper.snf.model.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Clinical categories of the ICD-10CM diagnosis codes
 */
public enum ClinicalCategory {
  ACUTE_INFECTIONS("Acute Infections"),
  ACUTE_NEUROLOGIC("Acute Neurologic"),
  CANCER("Cancer"),
  CARDIOVASCULAR_AND_COAGULATIONS("Cardiovascular and Coagulations"),
  MAJOR_JOINT_REPLACEMENT_OR_SPINAL_SURGERY("Major Joint Replacement or Spinal Surgery"),
  MEDICAL_MANAGEMENT("Medical Management"),
  NON_NEUROLOGIC("Non Neurologic"),
  NON_ORTHOPEDIC_SURGERY("Non-Orthopedic Surgery"),
  NON_SURGICAL_ORTHOPEDIC_MUSCULOSKELETAL("Non-Surgical Orthopedic/Musculoskeletal"),
  ORTHOPEDIC_SURGERY("Orthopedic Surgery (Except Major Joint Replacement or Spinal Surgery)"),
  OTHER_ORTHOPEDIC("Other Orthopedic"),
  PULMONARY("Pulmonary"),
  RETURN_TO_PROVIDER("Return to Provider");

  // Cache the list of enums
  private static final Map<String, ClinicalCategory> CACHE = new HashMap<>();
  private final String description;

  ClinicalCategory(String description) {
    this.description = description;
  }

  public static ClinicalCategory of(String description) {
    if (ClinicalCategory.CACHE.isEmpty()) {
      for (ClinicalCategory category : ClinicalCategory.values()) {
        ClinicalCategory.CACHE.put(category.getDescription(), category);
      }
    }

    return CACHE.get(description);
  }

  public String getDescription() {
    return description;
  }
}
