/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum PdxEligibility {
    ORTHOPEDIC_SURGERY("May be Eligible for One of the Two Orthopedic Surgery Categories"),
    NON_ORTHOPEDIC_SURGERY("May be Eligible for the Non-Orthopedic Surgery Category"),
    NOT_ELIGIBLE("N/A");

    private static final Map<String, PdxEligibility> CACHE;
    private final String description;

    private PdxEligibility(String description) {
        this.description = description;
    }

    public static Optional<PdxEligibility> of(String description) {
        return Optional.ofNullable(CACHE.get(description));
    }

    public String getDescription() {
        return this.description;
    }

    static {
        CACHE = new HashMap<String, PdxEligibility>();
        for (PdxEligibility eligibility : PdxEligibility.values()) {
            CACHE.put(eligibility.getDescription(), eligibility);
        }
    }
}

