/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.r2.logic;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.SnfTables;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.SnfProcessException;
import gov.cms.grouper.snf.model.enums.AssessmentType;
import gov.cms.grouper.snf.model.enums.ClinicalCategory;
import gov.cms.grouper.snf.model.enums.PdxEligibility;
import gov.cms.grouper.snf.model.enums.Rai300;
import gov.cms.grouper.snf.model.table.BasicRow;
import gov.cms.grouper.snf.model.table.ClinicalCategoryMasterRow;
import gov.cms.grouper.snf.model.table.CmgForPtOtRow;
import gov.cms.grouper.snf.r2.logic.SnfDataVersionImpl;
import gov.cms.grouper.snf.util.ClaimInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TherapyLogic
extends SnfDataVersionImpl<String> {
    private static final Logger log = LoggerFactory.getLogger(TherapyLogic.class);
    protected static final List<String> bedMobilityList = Arrays.asList("GG0170B", "GG0170C");
    protected static final List<String> transferList = Arrays.asList("GG0170D", "GG0170E", "GG0170F");
    protected static final List<String> walkingList = Arrays.asList("GG0170J", "GG0170K");
    protected static final List<String> generalItemList = Arrays.asList("GG0130A", "GG0130B", "GG0130C");
    private final BiFunction<ClaimInfo, String, Integer> functionalAssessments;
    private final Map<String, Integer> functionalAssessmentsMap;
    private final ClinicalCategory pdxClinicalCategory;
    private final Supplier<Integer> step3Supplier;

    public TherapyLogic(int version, ClaimInfo claim, ClinicalCategory pdxClinicalCategory) {
        super(version);
        this.pdxClinicalCategory = pdxClinicalCategory;
        this.functionalAssessmentsMap = claim.hasIpa() ? claim.getAssessments().stream().filter(item -> item.getItem().startsWith("GG") && item.getItem().endsWith("5")).collect(Collectors.toMap(item -> item.getItem().substring(0, item.getItem().length() - 1), Assessment::getValueInt)) : claim.getAssessments().stream().filter(item -> item.getItem().startsWith("GG") && item.getItem().endsWith("1")).collect(Collectors.toMap(item -> item.getItem().substring(0, item.getItem().length() - 1), Assessment::getValueInt));
        this.functionalAssessmentsMap.forEach((item, score) -> this.functionalAssessmentsMap.put((String)item, claim.performanceRecode(() -> score)));
        this.functionalAssessments = (assessmentList, code) -> this.functionalAssessmentsMap.get(code) == null ? Integer.valueOf(0) : this.functionalAssessmentsMap.get(code);
        this.step3Supplier = () -> claim.calculateFunctionScoreString(this.functionalAssessments, bedMobilityList, transferList, walkingList, generalItemList);
    }

    public static ClinicalCategory getPdxClinicalCategory(int version, ClaimInfo asstInfo, String pdx) {
        ClinicalCategoryMasterRow clinicalCategoryMasterRow = SnfTables.get(SnfTables.clinicalCategoryMasterTable, pdx, BasicRow::isVersion, version);
        if (clinicalCategoryMasterRow == null) {
            log.warn("Invalid ICD 10 code: " + pdx);
            return SnfContext.trace("Null clinical category because of invalid PDX " + pdx, null);
        }
        PdxEligibility pdxEligibility = clinicalCategoryMasterRow.getPdxEligibility();
        ClinicalCategory result = ClinicalCategory.of(clinicalCategoryMasterRow.getClinicalCategory()).orElseThrow(() -> new SnfProcessException("ClinicalCategory " + clinicalCategoryMasterRow.getClinicalCategory() + " not recognized. Data issue!"));
        if (pdxEligibility == PdxEligibility.ORTHOPEDIC_SURGERY) {
            if (asstInfo.isCheckedAndNotNull(Rai300.J2100)) {
                if (asstInfo.isAnyAssessmentValuesPresent(Rai300.getAssessmentsByType(AssessmentType.PROCEDURE_MAJOR), "MAJOR PROCEDURES")) {
                    result = ClinicalCategory.MAJOR_JOINT_REPLACEMENT_OR_SPINAL_SURGERY;
                } else if (asstInfo.isAnyAssessmentValuesPresent(Rai300.getAssessmentsByType(AssessmentType.PROCEDURE_ORTHOPEDIC), "ORTHOPEDIC PROCEDURES")) {
                    result = ClinicalCategory.ORTHOPEDIC_SURGERY;
                }
            }
        } else if (pdxEligibility == PdxEligibility.NON_ORTHOPEDIC_SURGERY && asstInfo.isCheckedAndNotNull(Rai300.J2100) && asstInfo.isAnyAssessmentValuesPresent(Rai300.getAssessmentsByType(AssessmentType.PROCEDURE_NON_ORTHOPEDIC), "NON-ORTHOPEDIC PROCEDURES")) {
            result = ClinicalCategory.NON_ORTHOPEDIC_SURGERY;
        }
        return SnfContext.trace(result);
    }

    protected static ClinicalCategory step2(int version, ClinicalCategory pdxClinicalCategory) {
        String clinicalCategory = SnfTables.get(SnfTables.clinicalCategoryMapping, pdxClinicalCategory.getDescription(), BasicRow::isVersion, version).getPtOtClinicalCategory();
        ClinicalCategory result = ClinicalCategory.of(clinicalCategory).orElseThrow(() -> new SnfProcessException("ClinicalCategory " + clinicalCategory + " not recognized. Data issue!"));
        return SnfContext.trace("Determined clinical category", result);
    }

    protected static CmgForPtOtRow step4(int version, Supplier<ClinicalCategory> clinicalCategorySupplier, Supplier<Integer> functionScoreSupplier) {
        Set<CmgForPtOtRow> list = SnfTables.getAll(SnfTables.cmgForPtOt, clinicalCategorySupplier.get().getDescription(), BasicRow::isVersion, version);
        Integer determinedScore = functionScoreSupplier.get();
        CmgForPtOtRow row = list.stream().filter(item -> item.getFunctionScoreLow() <= determinedScore && item.getFunctionScoreHigh() >= determinedScore).findFirst().orElse(null);
        if (row == null) {
            throw new SnfProcessException("Unable to determine CMG for Therapy Logic");
        }
        return SnfContext.trace(row);
    }

    @Override
    public String exec() {
        Supplier<ClinicalCategory> clinicalCategory = () -> TherapyLogic.step2(this.getDataVersion(), this.pdxClinicalCategory);
        CmgForPtOtRow result = TherapyLogic.step4(this.getDataVersion(), clinicalCategory, this.step3Supplier);
        return SnfContext.trace("----------- Therapy CMG", result.getCmg());
    }
}

