package gov.cms.grouper.snf.model.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum AssessmentIndicator {
    INTERIM_PAYMENT_ASSESSMENT(0),
    FIVE_DAY(1);

    private int value;
    private static final Map<Integer, AssessmentIndicator> valueMap = new HashMap<>();

    static {
        valueMap.put(0, INTERIM_PAYMENT_ASSESSMENT);
        valueMap.put(1, FIVE_DAY);
    }

    AssessmentIndicator(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public static Optional<AssessmentIndicator> of(Integer value) {
        return Optional.ofNullable(valueMap.get(value));
    }
}
