package gov.cms.grouper.snf.r2.logic;

/**
 * Base implementation for each Logic class.
 *
 * @param <T> The data type that ultimately gets return by the Logic class. This can either be a CMG
 *            String, CognitivieLevel, etc.
 */
public abstract class SnfDataVersionImpl<T> {

  private final int dataVersion;

  public SnfDataVersionImpl(int dataVersion) {
    this.dataVersion = dataVersion;
  }

  public int getDataVersion() {
    return dataVersion;
  }

  public abstract T exec();

}
