/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum ClinicalCategory {
    ACUTE_INFECTIONS("Acute Infections"),
    ACUTE_NEUROLOGIC("Acute Neurologic"),
    CANCER("Cancer"),
    CARDIOVASCULAR_AND_COAGULATIONS("Cardiovascular and Coagulations"),
    MAJOR_JOINT_REPLACEMENT_OR_SPINAL_SURGERY("Major Joint Replacement or Spinal Surgery"),
    MEDICAL_MANAGEMENT("Medical Management"),
    NON_NEUROLOGIC("Non Neurologic"),
    NON_ORTHOPEDIC_SURGERY("Non-Orthopedic Surgery"),
    NON_SURGICAL_ORTHOPEDIC_MUSCULOSKELETAL("Non-Surgical Orthopedic/Musculoskeletal"),
    ORTHOPEDIC_SURGERY("Orthopedic Surgery (Except Major Joint Replacement or Spinal Surgery)"),
    OTHER_ORTHOPEDIC("Other Orthopedic"),
    PULMONARY("Pulmonary"),
    RETURN_TO_PROVIDER("Return to Provider");

    private static final Map<String, ClinicalCategory> CACHE;
    private final String description;

    private ClinicalCategory(String description) {
        this.description = description;
    }

    public static Optional<ClinicalCategory> of(String description) {
        return Optional.ofNullable(CACHE.get(description));
    }

    public String getDescription() {
        return this.description;
    }

    static {
        CACHE = new HashMap<String, ClinicalCategory>();
        for (ClinicalCategory category : ClinicalCategory.values()) {
            CACHE.put(category.getDescription(), category);
        }
    }
}

